/*
 * Decompiled with CFR 0.152.
 */
package commonnetwork.api;

import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2535;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2818;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public interface NetworkHandler {
    default public <T> void sendToServer(T packet) {
        this.sendToServer(packet, false);
    }

    public <T> void sendToServer(T var1, boolean var2);

    default public <T> void sendToClient(T packet, class_3222 player) {
        this.sendToClient(packet, player, false);
    }

    public <T> void sendToClient(T var1, class_3222 var2, boolean var3);

    public <T> void send(T var1, class_2535 var2);

    @Nullable
    public <T> class_2658 getRawClientboundPacket(T var1);

    @Nullable
    public <T> class_2817 getRawServerboundPacket(T var1);

    default public <T> void sendToClients(T packet, List<class_3222> players) {
        this.sendToClients(packet, players, false);
    }

    default public <T> void sendToClients(T packet, List<class_3222> players, boolean ignoreCheck) {
        for (class_3222 player : players) {
            this.sendToClient(packet, player, ignoreCheck);
        }
    }

    default public <T> void sendToAllClients(T packet, MinecraftServer server) {
        this.sendToAllClients(packet, server, false);
    }

    default public <T> void sendToAllClients(T packet, MinecraftServer server, boolean ignoreCheck) {
        this.sendToClients(packet, server.method_3760().method_14571(), ignoreCheck);
    }

    default public <T> void sendToClientsInLevel(T packet, class_3218 level) {
        this.sendToClientsInLevel(packet, level, false);
    }

    default public <T> void sendToClientsInLevel(T packet, class_3218 level, boolean ignoreCheck) {
        this.sendToClients(packet, level.method_18456(), ignoreCheck);
    }

    default public <T> void sendToClientsLoadingChunk(T packet, class_2818 chunk) {
        this.sendToClientsLoadingChunk(packet, chunk, false);
    }

    default public <T> void sendToClientsLoadingChunk(T packet, class_2818 chunk, boolean ignoreCheck) {
        class_3215 chunkCache = (class_3215)chunk.method_12200().method_8398();
        this.sendToClients(packet, chunkCache.field_17254.method_17210(chunk.method_12004(), false), ignoreCheck);
    }

    default public <T> void sendToClientsLoadingPos(T packet, class_3218 level, class_1923 pos) {
        this.sendToClientsLoadingPos(packet, level, pos, false);
    }

    default public <T> void sendToClientsLoadingPos(T packet, class_3218 level, class_1923 pos, boolean ignoreCheck) {
        this.sendToClientsLoadingChunk(packet, level.method_8497(pos.field_9181, pos.field_9180), ignoreCheck);
    }

    default public <T> void sendToClientsLoadingPos(T packet, class_3218 level, class_2338 pos) {
        this.sendToClientsLoadingPos(packet, level, pos, false);
    }

    default public <T> void sendToClientsLoadingPos(T packet, class_3218 level, class_2338 pos, boolean ignoreCheck) {
        this.sendToClientsLoadingPos(packet, level, new class_1923(pos), ignoreCheck);
    }

    default public <T> void sendToClientsInRange(T packet, class_3218 level, class_2338 pos, double range) {
        this.sendToClientsInRange(packet, level, pos, range, false);
    }

    default public <T> void sendToClientsInRange(T packet, class_3218 level, class_2338 pos, double range, boolean ignoreCheck) {
        for (class_3222 player : level.method_18456()) {
            if (!(player.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()) <= range * range)) continue;
            this.sendToClient(packet, player, ignoreCheck);
        }
    }
}

