/*
 * Decompiled with CFR 0.152.
 */
package com.jimxbcn.clientlock.sync;

import com.jimxbcn.clientlock.ClientLockConfig;
import com.jimxbcn.clientlock.ClientLockLog;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;

public final class UpdaterSpawner {
    private UpdaterSpawner() {
    }

    public static boolean spawnAfterExit(ClientLockConfig cfg) {
        if (!cfg.sync().applyAfterExit()) {
            return false;
        }
        if (!UpdaterSpawner.hasPendingOps(cfg)) {
            return false;
        }
        try {
            List origins;
            long parentPid = ProcessHandle.current().pid();
            List roots = origins = FabricLoader.getInstance().getModContainer("clientlock").map(c -> {
                try {
                    return c.getOrigin().getPaths();
                }
                catch (Throwable t) {
                    return List.of();
                }
            }).orElse(List.of());
            if (roots.isEmpty()) {
                roots = FabricLoader.getInstance().getModContainer("clientlock").flatMap(c -> {
                    try {
                        return Optional.of(c.getRootPaths());
                    }
                    catch (Throwable t) {
                        return Optional.empty();
                    }
                }).orElse(List.of());
            }
            if (roots.isEmpty()) {
                ClientLockLog.LOGGER.warn("Could not resolve clientlock origin/root paths; cannot spawn updater.");
                return false;
            }
            ArrayList<String> classpathEntries = new ArrayList<String>();
            for (Path p : roots) {
                if (p == null) continue;
                Path cp = p.toAbsolutePath();
                if (Files.isRegularFile(cp, new LinkOption[0]) && cp.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".jar")) {
                    Path tmp = UpdaterSpawner.getUpdaterJarTarget();
                    Files.createDirectories(tmp.getParent(), new FileAttribute[0]);
                    Files.copy(cp, tmp, StandardCopyOption.REPLACE_EXISTING);
                    classpathEntries.add(tmp.toString());
                    continue;
                }
                classpathEntries.add(cp.toString());
            }
            if (classpathEntries.isEmpty()) {
                ClientLockLog.LOGGER.warn("Empty updater classpath; cannot spawn updater.");
                return false;
            }
            String cpSep = System.getProperty("path.separator");
            String classpath = String.join((CharSequence)cpSep, classpathEntries);
            String javaExe = UpdaterSpawner.resolveJavaExecutable();
            if (javaExe == null) {
                ClientLockLog.LOGGER.warn("Could not resolve java executable; cannot spawn updater.");
                return false;
            }
            String relaunchCmd = cfg.sync().relaunchCommand() == null ? "" : cfg.sync().relaunchCommand();
            String relaunchB64 = Base64.getEncoder().encodeToString(relaunchCmd.getBytes(StandardCharsets.UTF_8));
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(javaExe);
            cmd.add("-cp");
            cmd.add(classpath);
            cmd.add("com.jimxbcn.clientlock.sync.UpdaterMain");
            cmd.add(Long.toString(parentPid));
            cmd.add(cfg.sync().pendingDir());
            cmd.add(cfg.sync().quarantineDir());
            cmd.add(Boolean.toString(cfg.sync().relaunchEnabled()));
            cmd.add(relaunchB64);
            new ProcessBuilder(cmd).directory(Path.of(".", new String[0]).toFile()).inheritIO().start();
            ClientLockLog.LOGGER.info("Spawned updater process (applyAfterExit).");
            return true;
        }
        catch (Exception e) {
            ClientLockLog.LOGGER.warn("Failed spawning updater process", (Throwable)e);
            return false;
        }
    }

    private static Path getUpdaterJarTarget() {
        return Path.of("config", new String[0]).resolve("clientlock_updater.jar");
    }

    private static boolean hasPendingOps(ClientLockConfig cfg) {
        try {
            Path apply = Path.of("mods", new String[0]).resolve(cfg.sync().pendingDir()).resolve("apply.txt");
            if (!Files.isRegularFile(apply, new LinkOption[0])) {
                return false;
            }
            for (String line : Files.readAllLines(apply, StandardCharsets.UTF_8)) {
                String t = line.trim();
                if (t.isEmpty() || t.startsWith("#") || !t.startsWith("ADD|") && !t.startsWith("REMOVE|")) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String resolveJavaExecutable() {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null || javaHome.isBlank()) {
            return null;
        }
        boolean win = System.getProperty("os.name", "").toLowerCase(Locale.ROOT).contains("win");
        Path bin = Path.of(javaHome, "bin");
        Path java = bin.resolve(win ? "java.exe" : "java");
        if (Files.exists(java, new LinkOption[0])) {
            return java.toAbsolutePath().toString();
        }
        Path javaw = bin.resolve(win ? "javaw.exe" : "java");
        if (Files.exists(javaw, new LinkOption[0])) {
            return javaw.toAbsolutePath().toString();
        }
        return null;
    }
}

