/*
 * Decompiled with CFR 0.152.
 */
package com.jimxbcn.clientlock.sync;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.jimxbcn.clientlock.ClientLockConfig;
import com.jimxbcn.clientlock.ClientLockLog;
import com.jimxbcn.clientlock.ClientLockRuntime;
import com.jimxbcn.clientlock.sync.SplashStatus;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class PendingApplier {
    private static final Gson GSON = new Gson();

    private PendingApplier() {
    }

    public static boolean applyIfPresent(ClientLockConfig cfg) {
        Path modsDir = Path.of("mods", new String[0]);
        Path pendingDir = modsDir.resolve(cfg.sync().pendingDir());
        Path applyTxt = pendingDir.resolve("apply.txt");
        Path applyJson = pendingDir.resolve("apply.json");
        if (!Files.exists(applyTxt, new LinkOption[0]) && !Files.exists(applyJson, new LinkOption[0])) {
            return false;
        }
        SplashStatus.set(SplashStatus.Phase.APPLY_PENDING, "Aplicando actualizaciones del modpack\u2026", 0.05);
        try {
            ParsedApply apply;
            ParsedApply parsedApply = apply = Files.exists(applyTxt, new LinkOption[0]) ? PendingApplier.parseApplyTxt(applyTxt) : PendingApplier.parseApplyJson(applyJson);
            if (apply.removeFiles.isEmpty() && apply.addFiles.isEmpty()) {
                try {
                    Files.deleteIfExists(applyTxt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Files.deleteIfExists(applyJson);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
            Path quarantineDir = modsDir.resolve(cfg.sync().quarantineDir());
            Files.createDirectories(quarantineDir, new FileAttribute[0]);
            int total = apply.removeFiles.size() + apply.addFiles.size();
            int done = 0;
            for (String file : apply.removeFiles) {
                if (!file.isBlank()) {
                    PendingApplier.moveToQuarantine(modsDir.resolve(file), quarantineDir);
                }
                SplashStatus.set(SplashStatus.Phase.APPLY_PENDING, "Retirando mods antiguos\u2026", PendingApplier.progress(++done, total));
            }
            Path downloadsDir = pendingDir.resolve("downloads");
            for (String file : apply.addFiles) {
                if (!file.isBlank()) {
                    Path src = downloadsDir.resolve(file);
                    Path dst = modsDir.resolve(file);
                    if (Files.exists(dst, new LinkOption[0])) {
                        PendingApplier.moveToQuarantine(dst, quarantineDir);
                    }
                    if (Files.exists(src, new LinkOption[0])) {
                        PendingApplier.moveReplace(src, dst);
                    }
                }
                SplashStatus.set(SplashStatus.Phase.APPLY_PENDING, "Instalando mods nuevos\u2026", PendingApplier.progress(++done, total));
            }
            try {
                Files.deleteIfExists(applyTxt);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Files.deleteIfExists(applyJson);
            }
            catch (Exception exception) {
                // empty catch block
            }
            SplashStatus.set(SplashStatus.Phase.RESTART_REQUIRED, "Actualizaci\u00f3n aplicada. Reinicio requerido.", 1.0);
            if (cfg.sync().enforce()) {
                ClientLockRuntime.requestStop("Modpack updates applied; relaunch required");
            }
            return true;
        }
        catch (Exception e) {
            ClientLockLog.LOGGER.warn("Failed applying pending modpack changes", (Throwable)e);
            SplashStatus.set(SplashStatus.Phase.ERROR, "Fallo aplicando actualizaciones. Revisa logs.", 1.0);
            if (cfg.sync().enforce()) {
                ClientLockRuntime.requestStop("Failed applying pending changes");
            }
            return false;
        }
    }

    private static ParsedApply parseApplyTxt(Path applyTxt) throws Exception {
        ArrayList<String> remove = new ArrayList<String>();
        ArrayList<String> add = new ArrayList<String>();
        for (String raw : Files.readAllLines(applyTxt, StandardCharsets.UTF_8)) {
            int idx;
            String line;
            if (raw == null || (line = raw.trim()).isEmpty() || line.startsWith("#") || (idx = line.indexOf(124)) <= 0 || idx >= line.length() - 1) continue;
            String k = line.substring(0, idx).trim().toUpperCase(Locale.ROOT);
            String f = line.substring(idx + 1).trim();
            if (f.isEmpty()) continue;
            if (k.equals("REMOVE")) {
                remove.add(f);
                continue;
            }
            if (!k.equals("ADD")) continue;
            add.add(f);
        }
        return new ParsedApply(remove, add);
    }

    private static ParsedApply parseApplyJson(Path applyJson) throws Exception {
        String text = Files.readString(applyJson, StandardCharsets.UTF_8);
        JsonObject root = (JsonObject)GSON.fromJson(text, JsonObject.class);
        if (root == null) {
            throw new IllegalStateException("apply.json invalid");
        }
        ArrayList<String> remove = new ArrayList<String>();
        if (root.has("quarantine") && root.get("quarantine").isJsonArray()) {
            JsonArray arr = root.getAsJsonArray("quarantine");
            for (int i = 0; i < arr.size(); ++i) {
                if (!arr.get(i).isJsonPrimitive()) continue;
                remove.add(arr.get(i).getAsString());
            }
        }
        ArrayList<String> add = new ArrayList<String>();
        if (root.has("add") && root.get("add").isJsonArray()) {
            JsonArray arr = root.getAsJsonArray("add");
            for (int i = 0; i < arr.size(); ++i) {
                JsonObject o = arr.get(i).getAsJsonObject();
                if (!o.has("file")) continue;
                add.add(o.get("file").getAsString());
            }
        }
        return new ParsedApply(remove, add);
    }

    private static void moveToQuarantine(Path src, Path quarantineDir) throws Exception {
        if (!Files.exists(src, new LinkOption[0])) {
            return;
        }
        String name = src.getFileName().toString();
        String stamp = Instant.now().toString().replace(':', '-');
        Path dst = quarantineDir.resolve(stamp + "_" + name);
        PendingApplier.moveReplace(src, dst);
    }

    private static void moveReplace(Path src, Path dst) throws Exception {
        try {
            Files.createDirectories(dst.getParent(), new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Files.move(src, dst, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            Files.move(src, dst, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static float progress(int done, int total) {
        if (total <= 0) {
            return 1.0f;
        }
        return Math.min(1.0f, Math.max(0.0f, (float)done / (float)total));
    }

    private record ParsedApply(List<String> removeFiles, List<String> addFiles) {
    }
}

