/*
 * Decompiled with CFR 0.152.
 */
package com.jimxbcn.clientlock.sync;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jimxbcn.clientlock.ClientLockConfig;
import com.jimxbcn.clientlock.ClientLockLog;
import com.jimxbcn.clientlock.ClientLockRuntime;
import com.jimxbcn.clientlock.sync.FabricModJsonReader;
import com.jimxbcn.clientlock.sync.ModJarInfo;
import com.jimxbcn.clientlock.sync.SplashStatus;
import com.jimxbcn.clientlock.sync.UpdaterSpawner;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;

public final class ModSyncService {
    private static final Gson GSON = new GsonBuilder().create();

    private ModSyncService() {
    }

    public static void startSyncAsync(ClientLockConfig cfg) {
        Thread t = new Thread(() -> ModSyncService.run(cfg), "clientlock-sync");
        t.setDaemon(true);
        t.start();
    }

    private static void run(ClientLockConfig cfg) {
        block11: {
            try {
                boolean ok;
                Thread.sleep(150L);
                Map<String, ModJarInfo> clientById = ModSyncService.scanClientMods(cfg);
                SplashStatus.set(SplashStatus.Phase.CONTACTING_SERVER, "Contactando servidor del modpack\u2026", 0.35);
                JsonObject planResp = ModSyncService.requestPlan(cfg, clientById);
                boolean bl = ok = planResp.has("ok") && planResp.get("ok").getAsBoolean();
                if (!ok) {
                    throw new RuntimeException("Plan response not ok");
                }
                JsonObject plan = planResp.getAsJsonObject("plan");
                JsonArray download = plan.getAsJsonArray("download");
                JsonArray remove = plan.getAsJsonArray("remove");
                if (!(download != null && download.size() != 0 || remove != null && remove.size() != 0)) {
                    SplashStatus.set(SplashStatus.Phase.IN_SYNC, "Modpack sincronizado.", 1.0);
                    return;
                }
                if (remove != null && remove.size() > 0) {
                    JsonArray filtered = new JsonArray();
                    for (JsonElement el : remove) {
                        String id;
                        JsonObject o = el.getAsJsonObject();
                        String string = id = o.has("id") ? o.get("id").getAsString() : "";
                        if ("clientlock".equals(id)) continue;
                        filtered.add((JsonElement)o);
                    }
                    remove = filtered;
                }
                if (!(download != null && download.size() != 0 || remove != null && remove.size() != 0)) {
                    SplashStatus.set(SplashStatus.Phase.IN_SYNC, "Modpack sincronizado.", 1.0);
                    return;
                }
                if (cfg.sync().autoApply()) {
                    ModSyncService.stageChanges(cfg, clientById, download, remove);
                }
                SplashStatus.set(SplashStatus.Phase.RESTART_REQUIRED, "Se requieren cambios de mods. Reinicio obligatorio.", 1.0);
                if (cfg.sync().autoApply() && cfg.sync().applyAfterExit()) {
                    SplashStatus.set(SplashStatus.Phase.RESTART_REQUIRED, "Aplicando cambios al cerrar\u2026", 1.0);
                    UpdaterSpawner.spawnAfterExit(cfg);
                }
                if (cfg.sync().enforce()) {
                    ClientLockRuntime.requestStop("Modpack sync required");
                }
            }
            catch (InterruptedException clientById) {
            }
            catch (Exception e) {
                ClientLockLog.LOGGER.warn("Sync failed", (Throwable)e);
                SplashStatus.set(SplashStatus.Phase.ERROR, "Fallo de sincronizaci\u00f3n. Revisa logs.", 1.0);
                if (!cfg.sync().enforce()) break block11;
                ClientLockRuntime.requestStop("Sync failed");
            }
        }
    }

    private static Map<String, ModJarInfo> scanClientMods(ClientLockConfig cfg) throws Exception {
        SplashStatus.set(SplashStatus.Phase.SCANNING_LOCAL, "Escaneando mods locales\u2026", 0.1);
        Path modsDir = Path.of("mods", new String[0]);
        if (!Files.isDirectory(modsDir, new LinkOption[0])) {
            return Map.of();
        }
        HashMap<String, ModJarInfo> byId = new HashMap<String, ModJarInfo>();
        ArrayList<Path> jars = new ArrayList<Path>();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(modsDir, "*.jar");){
            for (Path p : ds) {
                jars.add(p);
            }
        }
        int total = Math.max(1, jars.size());
        int idx = 0;
        for (Path jar : jars) {
            ++idx;
            String jarPath = jar.toAbsolutePath().toString();
            Optional<FabricModJsonReader.FabricMod> fm = FabricModJsonReader.readPrimary(jarPath);
            if (fm.isEmpty()) continue;
            String id = fm.get().id();
            String version = fm.get().version();
            String file = jar.getFileName().toString();
            String sha = cfg.sync().sendSha256() ? ModSyncService.sha256(jar) : "";
            byId.put(id, new ModJarInfo(id, version, file, sha));
            SplashStatus.set(SplashStatus.Phase.SCANNING_LOCAL, "Escaneando mods\u2026 (" + idx + "/" + total + ")", 0.1 + 0.2 * ((double)idx / (double)total));
        }
        return byId;
    }

    private static JsonObject requestPlan(ClientLockConfig cfg, Map<String, ModJarInfo> clientById) throws Exception {
        JsonObject root = new JsonObject();
        root.addProperty("op", "plan");
        JsonObject map = new JsonObject();
        for (ModJarInfo m : clientById.values()) {
            JsonObject o = new JsonObject();
            o.addProperty("version", m.version());
            o.addProperty("file", m.fileName());
            if (m.sha256() != null && !m.sha256().isBlank()) {
                o.addProperty("sha256", m.sha256());
            }
            map.add(m.id(), (JsonElement)o);
        }
        root.add("clientModsById", (JsonElement)map);
        String body = GSON.toJson((JsonElement)root);
        HttpClient http = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(8L)).build();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(cfg.api().modsInventoryUrl())).timeout(Duration.ofSeconds(20L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body, StandardCharsets.UTF_8)).build();
        HttpResponse<String> resp = http.send(req, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        if (resp.statusCode() != 200) {
            throw new RuntimeException("Plan HTTP " + resp.statusCode());
        }
        JsonElement el = JsonParser.parseString((String)resp.body());
        if (!el.isJsonObject()) {
            throw new RuntimeException("Invalid JSON plan");
        }
        return el.getAsJsonObject();
    }

    private static void stageChanges(ClientLockConfig cfg, Map<String, ModJarInfo> clientById, JsonArray download, JsonArray remove) throws Exception {
        LinkedHashSet qset;
        String id;
        JsonObject o;
        Path modsDir = Path.of("mods", new String[0]);
        Path pendingDir = modsDir.resolve(cfg.sync().pendingDir());
        Path downloadsDir = pendingDir.resolve("downloads");
        Files.createDirectories(downloadsDir, new FileAttribute[0]);
        ArrayList<String> quarantineFiles = new ArrayList<String>();
        ArrayList<JsonObject> addEntries = new ArrayList<JsonObject>();
        int dTotal = download != null ? download.size() : 0;
        int rTotal = remove != null ? remove.size() : 0;
        int totalSteps = Math.max(1, dTotal + rTotal);
        int done = 0;
        if (remove != null) {
            for (JsonElement el : remove) {
                String file;
                o = el.getAsJsonObject();
                id = o.has("id") ? o.get("id").getAsString() : "";
                JsonObject client = o.has("client") && o.get("client").isJsonObject() ? o.getAsJsonObject("client") : null;
                String string = file = client != null && client.has("file") ? client.get("file").getAsString() : "";
                if (!file.isBlank()) {
                    quarantineFiles.add(file);
                }
                SplashStatus.set(SplashStatus.Phase.DOWNLOADING, "Planificando limpieza de mods\u2026", 0.4 + 0.1 * ((double)(++done) / (double)totalSteps));
            }
        }
        if (download != null) {
            HttpClient http = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(8L)).build();
            for (int i = 0; i < download.size(); ++i) {
                long size;
                o = download.get(i).getAsJsonObject();
                id = o.has("id") ? o.get("id").getAsString() : "";
                String reason = o.has("reason") ? o.get("reason").getAsString() : "";
                JsonObject target = o.getAsJsonObject("target");
                if (target == null) continue;
                String file = target.get("file").getAsString();
                String sha = target.has("sha256") ? target.get("sha256").getAsString() : "";
                long l = size = target.has("size") ? target.get("size").getAsLong() : 0L;
                if ("clientlock".equals(id) && !cfg.sync().allowSelfUpdate()) {
                    throw new RuntimeException("Self update required but allow_self_update=false");
                }
                ModJarInfo cur = clientById.get(id);
                if (cur != null && cur.fileName() != null && !cur.fileName().isBlank() && !cur.fileName().equals(file)) {
                    quarantineFiles.add(cur.fileName());
                }
                SplashStatus.set(SplashStatus.Phase.DOWNLOADING, "Descargando " + id + " (" + (i + 1) + "/" + dTotal + ")\u2026", 0.5 + 0.45 * ((double)i / (double)Math.max(1, dTotal)));
                ModSyncService.downloadJar(cfg, http, file, downloadsDir.resolve(file), sha, size);
                JsonObject add = new JsonObject();
                add.addProperty("file", file);
                add.addProperty("id", id);
                add.addProperty("reason", reason);
                addEntries.add(add);
                ++done;
            }
        }
        boolean hasOps = !(qset = new LinkedHashSet(quarantineFiles)).isEmpty() || !addEntries.isEmpty();
        Path applyTxt = pendingDir.resolve("apply.txt");
        if (!hasOps) {
            try {
                Files.deleteIfExists(applyTxt);
            }
            catch (Exception id2) {
                // empty catch block
            }
            try {
                Files.deleteIfExists(pendingDir.resolve("apply.json"));
            }
            catch (Exception id2) {
                // empty catch block
            }
            SplashStatus.set(SplashStatus.Phase.IN_SYNC, "Modpack sincronizado.", 1.0);
            return;
        }
        ArrayList<CallSite> applyLines = new ArrayList<CallSite>();
        applyLines.add((CallSite)((Object)("# clientlock apply file (generated " + String.valueOf(Instant.now()) + ")")));
        for (String f : qset) {
            applyLines.add((CallSite)((Object)("REMOVE|" + f)));
        }
        for (JsonObject o2 : addEntries) {
            if (!o2.has("file")) continue;
            applyLines.add((CallSite)((Object)("ADD|" + o2.get("file").getAsString())));
        }
        Files.write(applyTxt, applyLines, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        try {
            Files.deleteIfExists(pendingDir.resolve("apply.json"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        SplashStatus.set(SplashStatus.Phase.RESTART_REQUIRED, "Descargas completas. Reinicio requerido.", 1.0);
    }

    private static void downloadJar(ClientLockConfig cfg, HttpClient http, String file, Path out, String expectedSha256, long expectedSize) throws Exception {
        String got;
        long s;
        JsonObject root = new JsonObject();
        root.addProperty("op", "download");
        root.addProperty("file", file);
        String body = GSON.toJson((JsonElement)root);
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(cfg.api().modsInventoryUrl())).timeout(Duration.ofSeconds(60L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body, StandardCharsets.UTF_8)).build();
        HttpResponse<InputStream> resp = http.send(req, HttpResponse.BodyHandlers.ofInputStream());
        if (resp.statusCode() != 200) {
            throw new RuntimeException("Download HTTP " + resp.statusCode() + " for " + file);
        }
        Files.createDirectories(out.getParent(), new FileAttribute[0]);
        try (InputStream in = resp.body();){
            Files.copy(in, out, StandardCopyOption.REPLACE_EXISTING);
        }
        if (expectedSize > 0L && (s = Files.size(out)) != expectedSize) {
            throw new RuntimeException("Size mismatch for " + file);
        }
        if (expectedSha256 != null && !expectedSha256.isBlank() && !expectedSha256.equalsIgnoreCase(got = ModSyncService.sha256(out))) {
            throw new RuntimeException("SHA256 mismatch for " + file);
        }
    }

    private static String sha256(Path file) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            int r;
            byte[] buf = new byte[8192];
            while ((r = in.read(buf)) >= 0) {
                if (r <= 0) continue;
                md.update(buf, 0, r);
            }
        }
        byte[] dig = md.digest();
        StringBuilder sb = new StringBuilder(dig.length * 2);
        for (byte b : dig) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

