/*
 * Decompiled with CFR 0.152.
 */
package com.jimxbcn.clientlock.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jimxbcn.clientlock.ClientLockClient;
import com.jimxbcn.clientlock.ClientLockConfig;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_412;
import net.minecraft.class_4185;
import net.minecraft.class_429;
import net.minecraft.class_437;
import net.minecraft.class_4399;
import net.minecraft.class_442;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_639;
import net.minecraft.class_642;
import net.minecraft.class_644;
import net.minecraft.class_8519;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_442.class})
public abstract class TitleScreenMixin
extends class_437 {
    @Shadow
    @Nullable
    private class_4399 field_2592;
    @Shadow
    @Nullable
    private class_8519 field_2586;
    @Unique
    private static final class_2960 BACKGROUND = class_2960.method_60655((String)"clientlock", (String)"textures/gui/background.png");
    @Unique
    private static final Logger CLIENTLOCK_LOG = LoggerFactory.getLogger((String)"clientlock");
    @Unique
    private static int BG_W = 1920;
    @Unique
    private static int BG_H = 1080;
    @Unique
    private static boolean BG_DIM_LOADED = false;
    @Unique
    private static final int STATE_CHECKING = 0;
    @Unique
    private static final int STATE_ONLINE = 1;
    @Unique
    private static final int STATE_OFFLINE = 2;
    @Unique
    private static final int STATE_INCOMPATIBLE = 3;
    @Unique
    private static final long PING_INTERVAL_MS = 5000L;
    @Unique
    private static final long PING_TIMEOUT_MS = 3000L;
    @Unique
    private static final long PINGER_INVOKE_WATCHDOG_MS = 15000L;
    @Unique
    private final class_644 clientlock$pinger = new class_644();
    @Unique
    private long clientlock$nextPingAtMs = 0L;
    @Unique
    private boolean clientlock$pingInFlight = false;
    @Unique
    private long clientlock$pingStartedAtMs = 0L;
    @Unique
    private boolean clientlock$hasEverResolved = false;
    @Unique
    private boolean clientlock$pingDisabled = false;
    @Unique
    private boolean clientlock$debugDetails = false;
    @Unique
    private String clientlock$serverAddressStr = "";
    @Unique
    private String clientlock$serverHost = "";
    @Unique
    private int clientlock$serverPort = 25565;
    @Unique
    private int clientlock$serverState = 0;
    @Unique
    private long clientlock$lastPingMs = -1L;
    @Unique
    private class_2561 clientlock$lastMotd = class_2561.method_43470((String)"Comprobando servidor...").method_27692(class_124.field_1080);
    @Unique
    @Nullable
    private class_2561 clientlock$offlineMaintenanceMotd = null;
    @Unique
    private long clientlock$offlineMaintenanceFetchedAtMs = 0L;
    @Unique
    private boolean clientlock$offlineMaintenanceFetchInFlight = false;
    @Unique
    @Nullable
    private class_4185 clientlock$playButton;
    @Unique
    private final int clientlock$panelBg = -1442840576;
    @Unique
    private final int clientlock$panelOutline = 0x44FFFFFF;
    @Unique
    @Nullable
    private Method clientlock$pingerAdd3;
    @Unique
    @Nullable
    private Method clientlock$pingerAdd4;
    @Unique
    @Nullable
    private Class<?> clientlock$backendType;
    @Unique
    @Nullable
    private Method clientlock$pingerPing;
    @Unique
    private int clientlock$pingerPingArity = 0;
    @Unique
    private boolean clientlock$fallbackPolling = false;
    @Unique
    @Nullable
    private class_642 clientlock$inFlightInfo = null;
    @Unique
    private boolean clientlock$add4Scheduled = false;
    @Unique
    @Nullable
    private ClientLockConfig clientlock$cfg;
    @Unique
    private int clientlock$retryCount = 0;
    @Unique
    private static final int MAX_RETRIES = 3;

    protected TitleScreenMixin(class_2561 title) {
        super(title);
    }

    @Unique
    private String clientlock$checkingDots() {
        int phase = (int)(System.currentTimeMillis() / 400L % 4L);
        return switch (phase) {
            case 1 -> ".";
            case 2 -> "..";
            case 3 -> "...";
            default -> "";
        };
    }

    @Unique
    private String clientlock$updatingDotsSpaced() {
        int phase = (int)(System.currentTimeMillis() / 400L % 3L);
        return switch (phase) {
            case 1 -> ".";
            case 2 -> ". .";
            default -> ". . .";
        };
    }

    @Inject(method={"method_25426"}, at={@At(value="TAIL")})
    private void clientlock$init(CallbackInfo ci) {
        ClientLockConfig cfg;
        this.field_2592 = null;
        this.field_2586 = null;
        TitleScreenMixin.clientlock$loadBgDimensionsOnce();
        this.method_37067();
        this.clientlock$cfg = cfg = ClientLockClient.configOrDefault();
        try {
            this.clientlock$debugDetails = cfg.logging() != null && !cfg.logging().production();
        }
        catch (Throwable ignored) {
            this.clientlock$debugDetails = false;
        }
        this.clientlock$serverHost = cfg.server().host();
        this.clientlock$serverPort = cfg.server().port();
        this.clientlock$serverAddressStr = this.clientlock$serverHost + ":" + this.clientlock$serverPort;
        this.clientlock$serverState = 0;
        this.clientlock$lastPingMs = -1L;
        this.clientlock$lastMotd = class_2561.method_43470((String)"Comprobando servidor...").method_27692(class_124.field_1080);
        this.clientlock$nextPingAtMs = 0L;
        this.clientlock$pingStartedAtMs = 0L;
        this.clientlock$hasEverResolved = false;
        this.clientlock$pingInFlight = false;
        this.clientlock$pingDisabled = false;
        this.clientlock$fallbackPolling = false;
        this.clientlock$inFlightInfo = null;
        this.clientlock$retryCount = 0;
        this.clientlock$add4Scheduled = false;
        this.clientlock$pingerAdd3 = null;
        this.clientlock$pingerAdd4 = null;
        this.clientlock$backendType = null;
        this.clientlock$pingerPing = null;
        this.clientlock$pingerPingArity = 0;
        int centerX = this.field_22789 / 2;
        int groupTop = Math.round((float)this.field_22790 * 0.6f);
        int stackHeight = 92;
        int bottomMargin = 46;
        int maxTop = Math.max(0, this.field_22790 - bottomMargin - stackHeight);
        groupTop = Math.min(groupTop, maxTop);
        class_4185 play = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Jugar"), b -> this.clientlock$connect()).method_46434(centerX - 110, groupTop, 220, 20).method_46431();
        class_4185 options = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Opciones"), b -> {
            class_310 client = class_310.method_1551();
            client.method_1507((class_437)new class_429((class_437)this, client.field_1690));
        }).method_46434(centerX - 110, groupTop + 24, 220, 20).method_46431();
        class_4185 quit = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Cerrar Minecraft"), b -> class_310.method_1551().method_1592()).method_46434(centerX - 110, groupTop + 48, 220, 20).method_46431();
        this.clientlock$playButton = play;
        this.method_37063((class_364)play);
        this.method_37063((class_364)options);
        this.method_37063((class_364)quit);
        this.clientlock$updatePlayButtonLabel();
    }

    @Inject(method={"method_25393"}, at={@At(value="TAIL")})
    private void clientlock$tick(CallbackInfo ci) {
        long elapsed;
        long now = System.currentTimeMillis();
        if (this.clientlock$pingInFlight && this.clientlock$serverState == 0) {
            this.clientlock$lastMotd = class_2561.method_43470((String)("Comprobando servidor" + this.clientlock$checkingDots())).method_27692(class_124.field_1080);
        }
        if (this.clientlock$pingInFlight && this.clientlock$pingStartedAtMs > 0L && (elapsed = now - this.clientlock$pingStartedAtMs) > 3000L) {
            this.clientlock$pingInFlight = false;
            this.clientlock$pingStartedAtMs = 0L;
            this.clientlock$hasEverResolved = true;
            this.clientlock$serverState = 2;
            this.clientlock$lastPingMs = -1L;
            this.clientlock$lastMotd = this.clientlock$mkStatusText("Timeout esperando status ping", "Servidor sin conexi\u00f3n", class_124.field_1061);
        }
        if (!(this.clientlock$pingDisabled || this.clientlock$serverHost.isEmpty() || this.clientlock$pingInFlight || now < this.clientlock$nextPingAtMs)) {
            this.clientlock$nextPingAtMs = now + 5000L;
            this.clientlock$requestPing();
        }
        this.clientlock$updatePlayButtonLabel();
    }

    @Inject(method={"method_25432"}, at={@At(value="HEAD")})
    private void clientlock$removed(CallbackInfo ci) {
        try {
            this.clientlock$pinger.method_3004();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Unique
    private void clientlock$requestPing() {
        boolean wasOfflineWithMaintenance;
        if (this.clientlock$pingInFlight || this.clientlock$pingDisabled) {
            return;
        }
        this.clientlock$pingInFlight = true;
        this.clientlock$pingStartedAtMs = System.currentTimeMillis();
        boolean wasOnline = this.clientlock$serverState == 1;
        boolean bl = wasOfflineWithMaintenance = this.clientlock$serverState == 2 && this.clientlock$offlineMaintenanceMotd != null;
        if (!wasOnline && !wasOfflineWithMaintenance) {
            this.clientlock$serverState = 0;
            this.clientlock$lastMotd = class_2561.method_43470((String)("Comprobando servidor" + this.clientlock$checkingDots())).method_27692(class_124.field_1080);
        }
        String host = this.clientlock$serverHost;
        int port = this.clientlock$serverPort;
        int protocol = class_155.method_31372();
        Thread t = new Thread(() -> {
            boolean ok = false;
            long rttMs = -1L;
            String motd = null;
            String technical = null;
            try {
                long t0 = System.currentTimeMillis();
                String json = TitleScreenMixin.clientlock$statusRequest(host, port, protocol, 2500, 3500);
                long t1 = System.currentTimeMillis();
                motd = TitleScreenMixin.clientlock$extractMotd(json);
                ok = true;
                rttMs = Math.max(0L, t1 - t0);
            }
            catch (SocketTimeoutException ste) {
                technical = "SocketTimeoutException: " + ste.getMessage();
            }
            catch (IOException ioe) {
                technical = ioe.getClass().getSimpleName() + ": " + ioe.getMessage();
            }
            catch (Throwable th) {
                technical = th.getClass().getSimpleName() + ": " + th.getMessage();
            }
            boolean okF = ok;
            long rttF = rttMs;
            String motdF = motd;
            String techF = technical;
            class_310.method_1551().execute(() -> {
                this.clientlock$pingInFlight = false;
                this.clientlock$pingStartedAtMs = 0L;
                this.clientlock$hasEverResolved = true;
                if (okF) {
                    this.clientlock$serverState = 1;
                    this.clientlock$lastPingMs = rttF;
                    this.clientlock$lastMotd = motdF != null && !motdF.isBlank() ? class_2561.method_43470((String)motdF) : this.clientlock$mkStatusText("Status ping OK pero MOTD vac\u00edo", "Servidor disponible", class_124.field_1060);
                } else {
                    this.clientlock$serverState = 2;
                    this.clientlock$lastPingMs = -1L;
                    if (this.clientlock$offlineMaintenanceMotd != null) {
                        this.clientlock$lastMotd = this.clientlock$offlineMaintenanceMotd;
                    } else {
                        this.clientlock$lastMotd = this.clientlock$mkStatusText(techF != null ? techF : "Status ping failed", "Servidor sin conexi\u00f3n", class_124.field_1061);
                        this.clientlock$fetchOfflineMaintenanceAsync(false);
                    }
                }
                this.clientlock$updatePlayButtonLabel();
            });
        }, "clientlock-status-ping");
        t.setDaemon(true);
        t.start();
    }

    @Unique
    private void clientlock$invokeAdd4Async(Method add4, class_642 info, Object backend) {
        Thread t = new Thread(() -> {
            try {
                add4.invoke((Object)this.clientlock$pinger, info, () -> {}, () -> class_310.method_1551().execute(() -> this.clientlock$onPingFinished(info)), backend);
                this.clientlock$log("add4 invoked successfully: " + add4.getName());
            }
            catch (Throwable ex) {
                try {
                    String causeName;
                    Throwable cause = ex instanceof InvocationTargetException && ex.getCause() != null ? ex.getCause() : ex;
                    this.clientlock$log("add4 invoke exception: " + this.ignoredToString(cause));
                    if (this.clientlock$debugDetails) {
                        cause.printStackTrace();
                    }
                    if ((causeName = cause.getClass().getSimpleName()).contains("AnnotatedConnectException") || causeName.contains("ConnectException") || causeName.contains("TimeoutException")) {
                        try {
                            class_310.method_1551().execute(() -> {
                                this.clientlock$pingInFlight = false;
                                this.clientlock$serverState = 2;
                                this.clientlock$lastPingMs = -1L;
                                this.clientlock$lastMotd = this.clientlock$mkStatusText("Conexi\u00f3n al servidor fall\u00f3 (timeout)", "Servidor sin conexi\u00f3n", class_124.field_1061);
                                this.clientlock$nextPingAtMs = System.currentTimeMillis() + 5000L;
                            });
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.clientlock$startTcpProbe();
                        return;
                    }
                    try {
                        class_310.method_1551().execute(() -> {
                            this.clientlock$pingInFlight = false;
                        });
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.clientlock$startTcpProbe();
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        class_310.method_1551().execute(() -> {
                            this.clientlock$add4Scheduled = false;
                        });
                    }
                    catch (Throwable throwable) {}
                }
            }
            try {
                class_310.method_1551().execute(() -> {
                    this.clientlock$add4Scheduled = false;
                });
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }, "clientlock-pinger-add4-invoke");
        t.setDaemon(true);
        t.start();
        Thread wd = new Thread(() -> {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.clientlock$pingInFlight) {
                this.clientlock$log("pinger add4 invoke watchdog triggered after 15000ms");
                try {
                    class_310.method_1551().execute(() -> {
                        this.clientlock$pingInFlight = false;
                        this.clientlock$add4Scheduled = false;
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.clientlock$startTcpProbe();
            }
        }, "clientlock-pinger-watchdog");
        wd.setDaemon(true);
        wd.start();
    }

    @Unique
    private void clientlock$resolvePingerMethods() {
        Class<?>[] p;
        if (this.clientlock$pingerAdd3 != null || this.clientlock$pingerAdd4 != null || this.clientlock$pingerPing != null) {
            return;
        }
        for (Method m : class_644.class.getMethods()) {
            p = m.getParameterTypes();
            if (p.length == 3 && class_642.class.isAssignableFrom(p[0]) && Runnable.class.isAssignableFrom(p[1]) && Runnable.class.isAssignableFrom(p[2])) {
                this.clientlock$pingerAdd3 = m;
            }
            if (p.length == 4 && class_642.class.isAssignableFrom(p[0]) && Runnable.class.isAssignableFrom(p[1]) && Runnable.class.isAssignableFrom(p[2])) {
                this.clientlock$pingerAdd4 = m;
                this.clientlock$backendType = p[3];
            }
            if (p.length == 3 && InetSocketAddress.class.isAssignableFrom(p[0]) && class_639.class.isAssignableFrom(p[1]) && class_642.class.isAssignableFrom(p[2])) {
                this.clientlock$pingerPing = m;
                this.clientlock$pingerPingArity = 3;
            }
            if (p.length != 2 || !InetSocketAddress.class.isAssignableFrom(p[0]) || !class_642.class.isAssignableFrom(p[1])) continue;
            this.clientlock$pingerPing = m;
            this.clientlock$pingerPingArity = 2;
        }
        if (this.clientlock$pingerPing == null) {
            for (Method m : class_644.class.getDeclaredMethods()) {
                p = m.getParameterTypes();
                if (p.length == 3 && InetSocketAddress.class.isAssignableFrom(p[0]) && class_639.class.isAssignableFrom(p[1]) && class_642.class.isAssignableFrom(p[2])) {
                    m.setAccessible(true);
                    this.clientlock$pingerPing = m;
                    this.clientlock$pingerPingArity = 3;
                    break;
                }
                if (p.length != 2 || !InetSocketAddress.class.isAssignableFrom(p[0]) || !class_642.class.isAssignableFrom(p[1])) continue;
                m.setAccessible(true);
                this.clientlock$pingerPing = m;
                this.clientlock$pingerPingArity = 2;
                break;
            }
        }
        this.clientlock$log("resolvePingerMethods: add3=" + (this.clientlock$pingerAdd3 != null) + " add4=" + (this.clientlock$pingerAdd4 != null) + " pingMethod=" + (this.clientlock$pingerPing != null));
    }

    @Unique
    private boolean clientlock$startFallbackPing(class_642 info) {
        this.clientlock$resolvePingerMethods();
        if (this.clientlock$pingerPing == null || this.clientlock$pingerPingArity == 0) {
            return false;
        }
        try {
            InetSocketAddress inet = new InetSocketAddress(this.clientlock$serverHost, this.clientlock$serverPort);
            if (this.clientlock$pingerPingArity == 3) {
                class_639 addr = class_639.method_2950((String)this.clientlock$serverAddressStr);
                this.clientlock$pingerPing.invoke((Object)this.clientlock$pinger, inet, addr, info);
            } else {
                this.clientlock$pingerPing.invoke((Object)this.clientlock$pinger, inet, info);
            }
            this.clientlock$fallbackPolling = true;
            this.clientlock$pingStartedAtMs = System.currentTimeMillis();
            this.clientlock$inFlightInfo = info;
            this.clientlock$log("started fallback ping (arity=" + this.clientlock$pingerPingArity + ")");
            return true;
        }
        catch (Throwable t) {
            this.clientlock$lastMotd = this.clientlock$mkStatusText("Fallback ping() fall\u00f3: " + t.getClass().getSimpleName(), "No se pudo comprobar el servidor", class_124.field_1061);
            this.clientlock$log("fallback ping failed: " + this.ignoredToString(t));
            return false;
        }
    }

    @Unique
    private void clientlock$onPingFinished(class_642 info) {
        this.clientlock$pingInFlight = false;
        class_642.class_9083 status = info.method_55825();
        if (status == class_642.class_9083.field_47884) {
            this.clientlock$serverState = 1;
            this.clientlock$retryCount = 0;
        } else if (status == class_642.class_9083.field_47883) {
            this.clientlock$serverState = 3;
            this.clientlock$retryCount = 0;
        } else {
            this.clientlock$serverState = 2;
        }
        long pingVal = -1L;
        try {
            pingVal = info.field_3758;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.clientlock$lastPingMs = pingVal;
        class_2561 motdVal = this.clientlock$getMotdFromInfo(info);
        this.clientlock$lastMotd = status == class_642.class_9083.field_47884 && motdVal != null && !motdVal.getString().isBlank() ? motdVal : (status == class_642.class_9083.field_47883 ? this.clientlock$mkStatusText("Servidor incompatible con la versi\u00f3n del cliente", "Servidor incompatible", class_124.field_1065) : (status.name().equals("UNREACHABLE") || status.name().equals("CANNOT_CONNECT") || status.name().equals("FAILED") ? this.clientlock$mkStatusText("UNREACHABLE (no responde / cerrado / sin ruta)", "Servidor sin conexi\u00f3n", class_124.field_1061) : this.clientlock$mkStatusText("Estado: " + String.valueOf(status), "Servidor sin conexi\u00f3n", class_124.field_1061)));
        if (this.clientlock$inFlightInfo == info) {
            this.clientlock$inFlightInfo = null;
            this.clientlock$fallbackPolling = false;
            this.clientlock$add4Scheduled = false;
        }
        this.clientlock$updatePlayButtonLabel();
    }

    @Unique
    @Nullable
    private class_2561 clientlock$getMotdFromInfo(class_642 info) {
        String[] names;
        try {
            String[] v;
            Method m2;
            try {
                m2 = class_642.class.getMethod("getLabel", new Class[0]);
                v = m2.invoke((Object)info, new Object[0]);
                if (v instanceof class_2561) {
                    return (class_2561)v;
                }
            }
            catch (Throwable m2) {
                // empty catch block
            }
            try {
                m2 = class_642.class.getMethod("getDescription", new Class[0]);
                v = m2.invoke((Object)info, new Object[0]);
                if (v instanceof class_2561) {
                    return (class_2561)v;
                }
            }
            catch (Throwable m3) {}
        }
        catch (Throwable m3) {
            // empty catch block
        }
        for (String n : names = new String[]{"label", "motd", "description", "text"}) {
            try {
                Field f = class_642.class.getDeclaredField(n);
                f.setAccessible(true);
                Object v = f.get(info);
                if (!(v instanceof class_2561)) continue;
                return (class_2561)v;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            Field f = class_642.class.getField("label");
            Object v = f.get(info);
            if (v instanceof class_2561) {
                return (class_2561)v;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Unique
    private class_2561 clientlock$mkStatusText(String technical, String friendly, class_124 friendlyColor) {
        if (this.clientlock$debugDetails) {
            return class_2561.method_43470((String)technical).method_27692(class_124.field_1063);
        }
        return class_2561.method_43470((String)friendly).method_27692(friendlyColor);
    }

    @Unique
    private String clientlock$motdJsonUrl() {
        Object base = "https://minecraft.jimxbcn.xyz/";
        try {
            String u;
            if (this.clientlock$cfg != null && this.clientlock$cfg.api() != null && this.clientlock$cfg.api().url() != null && !(u = this.clientlock$cfg.api().url().trim()).isEmpty()) {
                base = u;
            }
        }
        catch (Throwable u) {
            // empty catch block
        }
        int q = ((String)base).indexOf(63);
        if (q >= 0) {
            base = ((String)base).substring(0, q);
        }
        if (!((String)base).endsWith("/")) {
            String tail;
            int lastSlash = ((String)base).lastIndexOf(47);
            base = lastSlash >= 0 ? ((tail = ((String)base).substring(lastSlash + 1)).contains(".") ? ((String)base).substring(0, lastSlash + 1) : (String)base + "/") : (String)base + "/";
        }
        return (String)base + "motd.json";
    }

    @Unique
    private void clientlock$fetchOfflineMaintenanceAsync(boolean force) {
        long now = System.currentTimeMillis();
        if (!force) {
            if (this.clientlock$offlineMaintenanceFetchInFlight) {
                return;
            }
            if (this.clientlock$offlineMaintenanceMotd != null && now - this.clientlock$offlineMaintenanceFetchedAtMs < 60000L) {
                return;
            }
        } else if (this.clientlock$offlineMaintenanceFetchInFlight) {
            return;
        }
        this.clientlock$offlineMaintenanceFetchInFlight = true;
        String url = this.clientlock$motdJsonUrl();
        Thread t = new Thread(() -> {
            class_5250 built = null;
            String err = null;
            try {
                InputStream is;
                HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
                conn.setConnectTimeout(1500);
                conn.setReadTimeout(2500);
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Accept", "application/json");
                int code = conn.getResponseCode();
                InputStream inputStream = is = code >= 200 && code < 300 ? conn.getInputStream() : conn.getErrorStream();
                if (is == null) {
                    throw new IOException("HTTP " + code + " sin body");
                }
                byte[] bytes = is.readAllBytes();
                String json = new String(bytes, StandardCharsets.UTF_8);
                JsonElement el = JsonParser.parseString((String)json);
                if (el != null && el.isJsonObject()) {
                    JsonArray maint;
                    JsonObject root = el.getAsJsonObject();
                    JsonArray jsonArray = maint = root.has("maintenance") && root.get("maintenance").isJsonArray() ? root.getAsJsonArray("maintenance") : null;
                    if (maint != null && maint.size() > 0 && maint.get(0).isJsonObject()) {
                        JsonObject m0 = maint.get(0).getAsJsonObject();
                        String title = m0.has("title") && m0.get("title").isJsonPrimitive() ? m0.get("title").getAsString() : "Mantenimiento";
                        String startsAt = m0.has("starts_at") && m0.get("starts_at").isJsonPrimitive() ? m0.get("starts_at").getAsString() : null;
                        long durMin = m0.has("duration_minutes") && m0.get("duration_minutes").isJsonPrimitive() ? m0.get("duration_minutes").getAsLong() : -1L;
                        String notes = m0.has("notes") && m0.get("notes").isJsonPrimitive() ? m0.get("notes").getAsString() : null;
                        built = this.clientlock$buildMaintenanceMotd(title, startsAt, durMin, notes);
                    } else {
                        String motd;
                        String string = motd = root.has("motd") && root.get("motd").isJsonPrimitive() ? root.get("motd").getAsString() : null;
                        if (motd != null && !motd.isBlank()) {
                            built = class_2561.method_43470((String)motd).method_27692(class_124.field_1065);
                        }
                    }
                }
            }
            catch (Throwable th) {
                err = th.getClass().getSimpleName() + ": " + th.getMessage();
            }
            class_5250 builtF = built;
            String errF = err;
            class_310.method_1551().execute(() -> {
                this.clientlock$offlineMaintenanceFetchInFlight = false;
                if (builtF != null) {
                    this.clientlock$offlineMaintenanceMotd = builtF;
                    this.clientlock$offlineMaintenanceFetchedAtMs = System.currentTimeMillis();
                    if (this.clientlock$serverState == 2) {
                        this.clientlock$lastMotd = builtF;
                    }
                    this.clientlock$log("maintenance motd loaded from " + url);
                } else if (errF != null) {
                    this.clientlock$log("maintenance motd fetch failed: " + errF);
                }
            });
        }, "clientlock-motd-json");
        t.setDaemon(true);
        t.start();
    }

    @Unique
    private class_2561 clientlock$buildMaintenanceMotd(String title, String startsAtIso, long durationMinutes, String notes) {
        class_5250 t = class_2561.method_43470((String)(title != null ? title : "Mantenimiento")).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
        OffsetDateTime start = null;
        OffsetDateTime end = null;
        try {
            if (startsAtIso != null && !startsAtIso.isBlank()) {
                start = OffsetDateTime.parse(startsAtIso);
                if (durationMinutes > 0L) {
                    end = start.plusMinutes(durationMinutes);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm", new Locale("es", "ES"));
        if (start != null) {
            t = t.method_10852((class_2561)class_2561.method_43470((String)"\n").method_27692(class_124.field_1070)).method_10852((class_2561)class_2561.method_43470((String)"Inicio: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)fmt.format(start)).method_27692(class_124.field_1068));
            if (end != null) {
                t = t.method_10852((class_2561)class_2561.method_43470((String)"  \u2022  ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Fin aprox.: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)fmt.format(end)).method_27692(class_124.field_1068));
            }
        }
        if (durationMinutes > 0L) {
            t = t.method_10852((class_2561)class_2561.method_43470((String)"\n").method_27692(class_124.field_1070)).method_10852((class_2561)class_2561.method_43470((String)"Duraci\u00f3n aprox.: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(durationMinutes + " min")).method_27692(class_124.field_1075));
        }
        if (notes != null && !notes.isBlank()) {
            t = t.method_10852((class_2561)class_2561.method_43470((String)"\n").method_27692(class_124.field_1070)).method_10852((class_2561)class_2561.method_43470((String)notes).method_27692(class_124.field_1063));
        }
        return t;
    }

    @Unique
    private void clientlock$updatePlayButtonLabel() {
        if (this.clientlock$playButton == null) {
            return;
        }
        class_5250 label = this.clientlock$serverState == 1 ? class_2561.method_43470((String)"Jugar").method_27692(class_124.field_1060) : (this.clientlock$serverState == 2 ? class_2561.method_43470((String)"Jugar").method_27692(class_124.field_1061) : (this.clientlock$serverState == 3 ? class_2561.method_43470((String)"Jugar").method_27692(class_124.field_1065) : class_2561.method_43470((String)"Jugar").method_27692(class_124.field_1054)));
        this.clientlock$playButton.method_25355((class_2561)label);
    }

    @Inject(method={"method_25394"}, at={@At(value="HEAD")}, cancellable=true)
    private void clientlock$render(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        try {
            this.clientlock$drawBackgroundContainMax(context);
            this.clientlock$drawServerStatus(context);
            super.method_25394(context, mouseX, mouseY, delta);
            this.clientlock$drawFooter(context);
            ci.cancel();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Unique
    private void clientlock$drawBackgroundContainMax(class_332 ctx) {
        int sw = this.field_22789;
        int sh = this.field_22790;
        ctx.method_25294(0, 0, sw, sh, -16777216);
        float scale = Math.min((float)sw / (float)BG_W, (float)sh / (float)BG_H);
        int dw = Math.round((float)BG_W * scale);
        int dh = Math.round((float)BG_H * scale);
        int x = (sw - dw) / 2;
        int y = (sh - dh) / 2;
        ctx.method_25302(class_10799.field_56883, BACKGROUND, x, y, 0.0f, 0.0f, dw, dh, BG_W, BG_H, BG_W, BG_H);
    }

    @Unique
    private void clientlock$drawServerStatus(class_332 ctx) {
        if (this.clientlock$playButton == null) {
            return;
        }
        int cardW = 220;
        int left = this.clientlock$playButton.method_46426();
        int playY = this.clientlock$playButton.method_46427();
        int sidePad = 8;
        int topPad = 7;
        class_2561 header = this.clientlock$buildHeaderText();
        List motdLines = this.field_22793.method_1728((class_5348)this.clientlock$lastMotd, cardW - sidePad * 2);
        int maxMotdLines = this.clientlock$serverState == 2 ? 6 : 2;
        int motdCount = Math.min(maxMotdLines, motdLines.size());
        Objects.requireNonNull(this.field_22793);
        int lineH = 9;
        int cardH = topPad + lineH + 3 + motdCount * lineH + topPad;
        int top = playY - 8 - cardH;
        if (top < 4) {
            top = 4;
        }
        ctx.method_25294(left, top, left + cardW, top + cardH, this.clientlock$panelBg);
        this.clientlock$drawOutline(ctx, left, top, cardW, cardH, this.clientlock$panelOutline);
        int y = top + topPad;
        ctx.method_27535(this.field_22793, header, left + sidePad, y, -1);
        y += lineH + 3;
        for (int i = 0; i < motdCount; ++i) {
            ctx.method_35720(this.field_22793, (class_5481)motdLines.get(i), left + sidePad, y + i * lineH, -2039584);
        }
    }

    @Unique
    private void clientlock$drawOutline(class_332 ctx, int x, int y, int w, int h, int argb) {
        ctx.method_25294(x, y, x + w, y + 1, argb);
        ctx.method_25294(x, y + h - 1, x + w, y + h, argb);
        ctx.method_25294(x, y, x + 1, y + h, argb);
        ctx.method_25294(x + w - 1, y, x + w, y + h, argb);
    }

    @Unique
    private class_2561 clientlock$buildHeaderText() {
        class_5250 prefix = class_2561.method_43470((String)"Servidor: ").method_27692(class_124.field_1080);
        if (this.clientlock$serverState == 1) {
            String ping = this.clientlock$lastPingMs >= 0L ? this.clientlock$lastPingMs + "ms" : "--";
            class_5250 t = prefix.method_10852((class_2561)class_2561.method_43470((String)"ONLINE").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"  ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)ping).method_27692(class_124.field_1060));
            if (this.clientlock$pingInFlight) {
                t = t.method_10852((class_2561)class_2561.method_43470((String)"  ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)this.clientlock$updatingDotsSpaced()).method_27692(class_124.field_1054));
            }
            return t;
        }
        if (this.clientlock$serverState == 2) {
            class_5250 t = prefix.method_10852((class_2561)class_2561.method_43470((String)"OFFLINE").method_27692(class_124.field_1061));
            if (this.clientlock$pingInFlight) {
                t = t.method_10852((class_2561)class_2561.method_43470((String)"  ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)this.clientlock$updatingDotsSpaced()).method_27692(class_124.field_1054));
            }
            return t;
        }
        if (this.clientlock$serverState == 3) {
            return prefix.method_10852((class_2561)class_2561.method_43470((String)"INCOMPATIBLE").method_27692(class_124.field_1065));
        }
        return prefix.method_10852((class_2561)class_2561.method_43470((String)("COMPROBANDO" + this.clientlock$checkingDots())).method_27692(class_124.field_1054));
    }

    @Unique
    private void clientlock$drawFooter(class_332 context) {
        String line1 = "Modpack JimXBCN version: " + ClientLockClient.modVersion();
        String mcVer = class_155.method_16673().comp_4025();
        String line2 = "Minecraft " + mcVer + "/Fabric (con mods)";
        int x = 2;
        int y2 = this.field_22790 - 10;
        int y1 = y2 - 10;
        context.method_51433(this.field_22793, line1, x, y1, -1, true);
        context.method_51433(this.field_22793, line2, x, y2, -1, true);
    }

    @Unique
    private void clientlock$connect() {
        ClientLockConfig cfg = this.clientlock$cfg != null ? this.clientlock$cfg : ClientLockClient.configOrDefault();
        class_310 client = class_310.method_1551();
        String addrStr = cfg.server().host() + ":" + cfg.server().port();
        class_639 addr = class_639.method_2950((String)addrStr);
        class_642 info = new class_642("JimXBCN", addrStr, class_642.class_8678.field_45611);
        class_412.method_36877((class_437)this, (class_310)client, (class_639)addr, (class_642)info, (boolean)false, null);
    }

    @Unique
    private static void clientlock$loadBgDimensionsOnce() {
        if (BG_DIM_LOADED) {
            return;
        }
        BG_DIM_LOADED = true;
        String cp = "/assets/clientlock/textures/gui/background.png";
        try (InputStream in = TitleScreenMixin.class.getResourceAsStream(cp);){
            if (in == null) {
                return;
            }
            class_1011 img = class_1011.method_4309((InputStream)in);
            BG_W = img.method_4307();
            BG_H = img.method_4323();
            img.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Unique
    @Nullable
    private Object clientlock$resolveBackendFromClientFields(@Nullable Class<?> backendType) {
        if (backendType == null) {
            return null;
        }
        class_310 client = class_310.method_1551();
        for (Class<?> c = client.getClass(); c != null; c = c.getSuperclass()) {
            try {
                for (Field f : c.getDeclaredFields()) {
                    if (!backendType.isAssignableFrom(f.getType())) continue;
                    f.setAccessible(true);
                    Object v = f.get(client);
                    if (v == null) continue;
                    return v;
                }
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Unique
    @Nullable
    private Object clientlock$resolveBackendFallback(@Nullable Class<?> bt) {
        block21: {
            if (bt == null) {
                return null;
            }
            try {
                Object v2;
                Method remote = null;
                for (Method m : bt.getMethods()) {
                    if (!Modifier.isStatic(m.getModifiers()) || !m.getName().equals("remote") || m.getParameterCount() != 1 || m.getParameterTypes()[0] != Boolean.TYPE && m.getParameterTypes()[0] != Boolean.class || !bt.isAssignableFrom(m.getReturnType())) continue;
                    remote = m;
                    break;
                }
                if (remote == null) break block21;
                try {
                    v2 = remote.invoke(null, true);
                    if (v2 != null) {
                        return v2;
                    }
                }
                catch (Throwable v2) {
                    // empty catch block
                }
                try {
                    v2 = remote.invoke(null, false);
                    if (v2 != null) {
                        return v2;
                    }
                }
                catch (Throwable v3) {}
            }
            catch (Throwable remote) {
                // empty catch block
            }
        }
        try {
            ?[] c;
            if (bt.isEnum() && (c = bt.getEnumConstants()) != null && c.length > 0) {
                Object preferred = null;
                for (Object o : c) {
                    String name = String.valueOf(o).toUpperCase();
                    if (!name.contains("VANILLA") && !name.contains("DEFAULT") && !name.contains("TCP") && !name.contains("SOCKET")) continue;
                    preferred = o;
                    break;
                }
                if (preferred == null) {
                    preferred = c[0];
                }
                if (preferred != null) {
                    return preferred;
                }
            }
        }
        catch (Throwable c) {
            // empty catch block
        }
        try {
            Object v;
            Field pick;
            Field preferred = null;
            Field first = null;
            for (Field f : bt.getDeclaredFields()) {
                String n;
                if (!Modifier.isStatic(f.getModifiers()) || !bt.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                if (first == null) {
                    first = f;
                }
                if (!(n = f.getName().toUpperCase()).contains("DEFAULT") && !n.contains("VANILLA")) continue;
                preferred = f;
                break;
            }
            Field field = pick = preferred != null ? preferred : first;
            if (pick != null && (v = pick.get(null)) != null) {
                return v;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Unique
    private void clientlock$startTcpProbe() {
        String hostFinal = this.clientlock$serverHost;
        int portFinal = this.clientlock$serverPort;
        Thread t = new Thread(() -> {
            long start = System.currentTimeMillis();
            boolean ok = false;
            try (Socket s = new Socket();){
                s.connect(new InetSocketAddress(hostFinal, portFinal), 3000);
                ok = true;
            }
            catch (Throwable ignored) {
                ok = false;
            }
            long rtt = System.currentTimeMillis() - start;
            boolean okFinal = ok;
            long rttFinal = rtt;
            try {
                class_310.method_1551().execute(() -> {
                    this.clientlock$pingInFlight = false;
                    if (okFinal) {
                        this.clientlock$serverState = 1;
                        this.clientlock$lastPingMs = rttFinal;
                        this.clientlock$lastMotd = this.clientlock$mkStatusText("Fallback TCP OK (sin MOTD). RTT=" + rttFinal + "ms", "Servidor disponible", class_124.field_1060);
                        this.clientlock$log("TCP fallback OK RTT=" + rttFinal + "ms");
                    } else {
                        this.clientlock$serverState = 2;
                        this.clientlock$lastPingMs = -1L;
                        this.clientlock$lastMotd = this.clientlock$mkStatusText("Fallback TCP FAIL (host/puerto cerrado o sin ruta)", "Servidor sin conexi\u00f3n", class_124.field_1061);
                        this.clientlock$log("TCP fallback FAIL");
                    }
                    this.clientlock$add4Scheduled = false;
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, "clientlock-tcp-probe");
        t.setDaemon(true);
        t.start();
    }

    @Unique
    private void clientlock$log(String msg) {
        try {
            if (this.clientlock$debugDetails) {
                CLIENTLOCK_LOG.info(msg);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Unique
    private String ignoredToString(Throwable t) {
        try {
            if (t == null) {
                return "<null>";
            }
            String n = t.getClass().getSimpleName();
            String m = t.getMessage();
            return n + (String)(m != null ? " - " + m : "");
        }
        catch (Throwable ignored) {
            return "<err>";
        }
    }

    /*
     * Exception decompiling
     */
    @Unique
    private static String clientlock$statusRequest(String host, int port, int protocolVersion, int connectTimeoutMs, int readTimeoutMs) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Unique
    private static String clientlock$extractMotd(String json) {
        if (json == null || json.isBlank()) {
            return null;
        }
        try {
            JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
            if (!root.has("description")) {
                return null;
            }
            JsonElement desc = root.get("description");
            return TitleScreenMixin.clientlock$flattenText(desc);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Unique
    private static String clientlock$flattenText(JsonElement el) {
        if (el == null || el.isJsonNull()) {
            return null;
        }
        if (el.isJsonPrimitive()) {
            return el.getAsString();
        }
        if (el.isJsonArray()) {
            JsonArray arr = el.getAsJsonArray();
            StringBuilder sb = new StringBuilder();
            for (JsonElement e : arr) {
                String p = TitleScreenMixin.clientlock$flattenText(e);
                if (p == null) continue;
                sb.append(p);
            }
            return sb.toString();
        }
        if (el.isJsonObject()) {
            JsonObject obj = el.getAsJsonObject();
            StringBuilder sb = new StringBuilder();
            if (obj.has("text") && obj.get("text").isJsonPrimitive()) {
                sb.append(obj.get("text").getAsString());
            }
            if (obj.has("extra") && obj.get("extra").isJsonArray()) {
                for (JsonElement e : obj.getAsJsonArray("extra")) {
                    String p = TitleScreenMixin.clientlock$flattenText(e);
                    if (p == null) continue;
                    sb.append(p);
                }
            }
            return sb.toString();
        }
        return null;
    }

    @Unique
    private static void writePacket(DataOutputStream out, byte[] packetData) throws IOException {
        TitleScreenMixin.writeVarInt(out, packetData.length);
        out.write(packetData);
        out.flush();
    }

    @Unique
    private static byte[] readPacket(DataInputStream in) throws IOException {
        int length = TitleScreenMixin.readVarInt(in);
        if (length < 0 || length > 0x100000) {
            throw new IOException("Invalid packet length: " + length);
        }
        byte[] data = new byte[length];
        in.readFully(data);
        return data;
    }

    @Unique
    private static void writeString(DataOutputStream out, String s) throws IOException {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        TitleScreenMixin.writeVarInt(out, b.length);
        out.write(b);
    }

    @Unique
    private static String readString(DataInputStream in) throws IOException {
        int len = TitleScreenMixin.readVarInt(in);
        if (len < 0 || len > 0x100000) {
            throw new IOException("Invalid string length: " + len);
        }
        byte[] b = new byte[len];
        in.readFully(b);
        return new String(b, StandardCharsets.UTF_8);
    }

    @Unique
    private static void writeVarInt(DataOutputStream out, int value) throws IOException {
        int v = value;
        while ((v & 0xFFFFFF80) != 0) {
            out.writeByte(v & 0x7F | 0x80);
            v >>>= 7;
        }
        out.writeByte(v & 0x7F);
    }

    @Unique
    private static int readVarInt(DataInputStream in) throws IOException {
        byte read;
        int numRead = 0;
        int result = 0;
        do {
            read = in.readByte();
            int value = read & 0x7F;
            result |= value << 7 * numRead;
            if (++numRead <= 5) continue;
            throw new IOException("VarInt too big");
        } while ((read & 0x80) != 0);
        return result;
    }
}

