/*
 * Decompiled with CFR 0.152.
 */
package com.jimxbcn.clientlock;

import com.jimxbcn.clientlock.ClientLockConfig;
import com.jimxbcn.clientlock.ClientLockLog;
import com.jimxbcn.clientlock.TomlLite;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class ConfigManager {
    private static final String FILE_NAME = "clientlock.toml";

    private ConfigManager() {
    }

    public static ClientLockConfig loadOrCreate() {
        Path cfgDir = Path.of("config", new String[0]);
        Path cfgFile = cfgDir.resolve(FILE_NAME);
        try {
            String text;
            ClientLockConfig parsed;
            if (Files.notExists(cfgDir, new LinkOption[0])) {
                Files.createDirectories(cfgDir, new FileAttribute[0]);
            }
            if (Files.exists(cfgFile, new LinkOption[0]) && (parsed = TomlLite.parse(text = Files.readString(cfgFile, StandardCharsets.UTF_8))) != null) {
                return parsed;
            }
        }
        catch (Exception e) {
            ClientLockLog.LOGGER.warn("Invalid config; using defaults. File={}", (Object)cfgFile, (Object)e);
        }
        ClientLockConfig def = ClientLockConfig.defaults();
        try {
            Files.writeString(cfgFile, (CharSequence)TomlLite.toToml(def), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            ClientLockLog.LOGGER.warn("Could not write default config {}", (Object)cfgFile, (Object)e);
        }
        return def;
    }
}

