/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.splitter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import net.fabricmc.fabric.impl.networking.GenericPayloadAccessor;
import net.fabricmc.fabric.impl.networking.PayloadTypeRegistryImpl;
import net.fabricmc.fabric.impl.networking.VanillaPacketTypes;
import net.fabricmc.fabric.impl.networking.splitter.FabricSplitPacketPayload;
import net.fabricmc.fabric.mixin.networking.accessor.PacketDecoderAccessor;
import net.minecraft.class_2543;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_8703;
import net.minecraft.class_8710;
import net.minecraft.class_9145;
import org.jspecify.annotations.Nullable;

public class FabricPacketMerger
extends MessageToMessageDecoder<class_2596<?>> {
    private final class_2543<?> decoderHandler;
    private final PayloadTypeRegistryImpl<?> payloadTypeRegistry;
    private final VanillaPacketTypes vanillaPacketTypes;
    private @Nullable Merger packetMerger;

    public FabricPacketMerger(class_2543<?> decoderHandler, PayloadTypeRegistryImpl<?> payloadTypeRegistry, VanillaPacketTypes vanillaPacketTypes) {
        this.decoderHandler = decoderHandler;
        this.payloadTypeRegistry = payloadTypeRegistry;
        this.vanillaPacketTypes = vanillaPacketTypes;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, class_2596<?> packet, List<Object> list) throws Exception {
        GenericPayloadAccessor accessor;
        class_8710 payload2;
        if (this.packetMerger != null) {
            class_8710 payload2;
            FabricPacketMerger.ensureNotTransitioning(packet);
            if (packet instanceof GenericPayloadAccessor) {
                GenericPayloadAccessor accessor2 = (GenericPayloadAccessor)packet;
                v0 = accessor2.fabric_payload();
            } else {
                v0 = payload2 = null;
            }
            if (payload2 == null) {
                throw new DecoderException("Received '" + String.valueOf(packet.method_65080().comp_2231()) + "' packet, while expecting 'minecraft:custom_payload'!");
            }
            if (!(payload2 instanceof FabricSplitPacketPayload)) {
                throw new DecoderException("Expected '" + String.valueOf(FabricSplitPacketPayload.ID.comp_2242()) + "' payload packet, but received '" + String.valueOf(payload2.method_56479().comp_2242()) + "'!");
            }
            FabricSplitPacketPayload splitPacketPayload = (FabricSplitPacketPayload)payload2;
            if (this.packetMerger.add(channelHandlerContext, splitPacketPayload, list)) {
                this.packetMerger = null;
            }
        } else if (packet instanceof GenericPayloadAccessor && (payload2 = (accessor = (GenericPayloadAccessor)packet).fabric_payload()) instanceof FabricSplitPacketPayload) {
            FabricSplitPacketPayload payload3 = (FabricSplitPacketPayload)payload2;
            FabricPacketMerger.ensureNotTransitioning(packet);
            ByteBuf buf = payload3.byteBuf();
            int packetSize = class_8703.method_53016((ByteBuf)buf);
            int readerIndex = buf.readerIndex();
            class_9145<?> packetType = this.vanillaPacketTypes.get(class_8703.method_53016((ByteBuf)buf));
            if (packetType != packet.method_65080()) {
                throw new DecoderException("Received unsupported split packet type! Expected '" + String.valueOf(packet.method_65080().comp_2231()) + " got '" + String.valueOf(packetType != null ? packetType.comp_2231() : "<NULL>") + "'!");
            }
            class_2960 payloadId = (class_2960)class_2960.field_48267.decode((Object)payload3.byteBuf());
            buf.readerIndex(readerIndex);
            int maxSize = this.payloadTypeRegistry.getMaxPacketSize(payloadId);
            if (maxSize == -1) {
                throw new DecoderException("Received '" + String.valueOf(payloadId) + "' packet doesn't support splitting, but received split data!");
            }
            if (maxSize < packetSize) {
                throw new DecoderException("Received '" + String.valueOf(payloadId) + "' packet is larger than max allowed size! Got " + packetSize + " bytes, expected " + maxSize + " bytes!");
            }
            this.packetMerger = new Merger(this.decoderHandler, payloadId, packetSize);
            if (this.packetMerger.add(channelHandlerContext, payload3, list)) {
                throw new DecoderException("Received '" + String.valueOf(payloadId) + "' as a split packet, but it wasn't actually split!");
            }
        } else {
            list.add(packet);
            if (packet.method_55943()) {
                channelHandlerContext.pipeline().remove(channelHandlerContext.name());
            }
        }
    }

    private static void ensureNotTransitioning(class_2596<?> packet) {
        if (packet.method_55943()) {
            throw new DecoderException("Terminal message received in bundle");
        }
    }

    private static class Merger {
        private final PacketDecoderAccessor decoderHandler;
        private final class_2960 packetId;
        private final int finalSize;
        private final ByteBuf byteBuf;

        Merger(class_2543<?> decoderHandler, class_2960 identifier, int finalSize) {
            this.decoderHandler = (PacketDecoderAccessor)decoderHandler;
            this.packetId = identifier;
            this.byteBuf = Unpooled.buffer((int)finalSize);
            this.finalSize = finalSize;
        }

        boolean add(ChannelHandlerContext channelHandlerContext, FabricSplitPacketPayload payload, List<Object> objects) throws Exception {
            int newSize = this.byteBuf.readableBytes() + payload.byteBuf().readableBytes();
            if (this.finalSize < newSize) {
                throw new DecoderException("Received too much data for packet '" + String.valueOf(this.packetId) + "'! Expected " + this.finalSize + " bytes, received " + newSize + " bytes!");
            }
            this.byteBuf.writeBytes(payload.byteBuf());
            if (this.byteBuf.readableBytes() == this.finalSize) {
                this.decoderHandler.fabric_decode(channelHandlerContext, this.byteBuf, objects);
                return true;
            }
            return false;
        }
    }
}

