/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.jfr.Configuration;
import jdk.jfr.Event;
import jdk.jfr.FlightRecorder;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.Recording;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2539;
import net.minecraft.class_3195;
import net.minecraft.class_4239;
import net.minecraft.class_4486;
import net.minecraft.class_5321;
import net.minecraft.class_6506;
import net.minecraft.class_6507;
import net.minecraft.class_6611;
import net.minecraft.class_6613;
import net.minecraft.class_6880;
import net.minecraft.class_9145;
import net.minecraft.class_9240;
import net.minecraft.util.profiling.jfr.event.ChunkGenerationEvent;
import net.minecraft.util.profiling.jfr.event.ChunkRegionReadEvent;
import net.minecraft.util.profiling.jfr.event.ChunkRegionWriteEvent;
import net.minecraft.util.profiling.jfr.event.ClientFpsEvent;
import net.minecraft.util.profiling.jfr.event.NetworkSummaryEvent;
import net.minecraft.util.profiling.jfr.event.PacketReceivedEvent;
import net.minecraft.util.profiling.jfr.event.PacketSentEvent;
import net.minecraft.util.profiling.jfr.event.ServerTickTimeEvent;
import net.minecraft.util.profiling.jfr.event.StructureGenerationEvent;
import net.minecraft.util.profiling.jfr.event.WorldLoadFinishedEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class class_6505
implements class_6611 {
    private static final Logger field_34408 = LogUtils.getLogger();
    public static final String field_34403 = "Minecraft";
    public static final String field_34404 = "World Generation";
    public static final String field_34405 = "Ticking";
    public static final String field_34406 = "Network";
    public static final String field_49058 = "Storage";
    private static final List<Class<? extends Event>> field_34407 = List.of(ChunkGenerationEvent.class, ChunkRegionReadEvent.class, ChunkRegionWriteEvent.class, PacketReceivedEvent.class, PacketSentEvent.class, NetworkSummaryEvent.class, ServerTickTimeEvent.class, ClientFpsEvent.class, StructureGenerationEvent.class, WorldLoadFinishedEvent.class);
    private static final String field_34409 = "/flightrecorder-config.jfc";
    private static final DateTimeFormatter field_34410 = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd-HHmmss").toFormatter(Locale.ROOT).withZone(ZoneId.systemDefault());
    private static final class_6505 field_35576 = new class_6505();
    @Nullable Recording field_34411;
    private int field_63275;
    private float field_35577;
    private final Map<String, NetworkSummaryEvent.class_6779> field_35578 = new ConcurrentHashMap<String, NetworkSummaryEvent.class_6779>();
    private final Runnable field_63276 = () -> new ClientFpsEvent(this.field_63275).commit();
    private final Runnable field_63277 = () -> new ServerTickTimeEvent(this.field_35577).commit();
    private final Runnable field_63278 = () -> {
        Iterator<NetworkSummaryEvent.class_6779> $$0 = this.field_35578.values().iterator();
        while ($$0.hasNext()) {
            $$0.next().method_39494();
            $$0.remove();
        }
    };

    private class_6505() {
        field_34407.forEach(FlightRecorder::register);
        this.method_75089();
        FlightRecorder.addListener(new FlightRecorderListener(){

            @Override
            public void recordingStateChanged(Recording $$0) {
                switch ($$0.getState()) {
                    case STOPPED: {
                        class_6505.this.method_75089();
                        break;
                    }
                }
            }
        });
    }

    void method_75089() {
        class_6505.method_75088(ClientFpsEvent.class, this.field_63276);
        class_6505.method_75088(ServerTickTimeEvent.class, this.field_63277);
        class_6505.method_75088(NetworkSummaryEvent.class, this.field_63278);
    }

    private static void method_75088(Class<? extends Event> $$0, Runnable $$1) {
        FlightRecorder.removePeriodicEvent($$1);
        FlightRecorder.addPeriodicEvent($$0, $$1);
    }

    public static class_6505 method_39428() {
        return field_35576;
    }

    @Override
    public boolean method_37981(class_6506 $$0) {
        boolean bl;
        URL $$1 = class_6505.class.getResource(field_34409);
        if ($$1 == null) {
            field_34408.warn("Could not find default flight recorder config at {}", (Object)field_34409);
            return false;
        }
        BufferedReader $$2 = new BufferedReader(new InputStreamReader($$1.openStream(), StandardCharsets.UTF_8));
        try {
            bl = this.method_37983($$2, $$0);
        }
        catch (Throwable throwable) {
            try {
                try {
                    $$2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException $$3) {
                field_34408.warn("Failed to start flight recorder using configuration at {}", (Object)$$1, (Object)$$3);
                return false;
            }
        }
        $$2.close();
        return bl;
    }

    @Override
    public Path method_37980() {
        if (this.field_34411 == null) {
            throw new IllegalStateException("Not currently profiling");
        }
        this.field_35578.clear();
        Path $$0 = this.field_34411.getDestination();
        this.field_34411.stop();
        return $$0;
    }

    @Override
    public boolean method_37984() {
        return this.field_34411 != null;
    }

    @Override
    public boolean method_38658() {
        return FlightRecorder.isAvailable();
    }

    private boolean method_37983(Reader $$0, class_6506 $$1) {
        if (this.method_37984()) {
            field_34408.warn("Profiling already in progress");
            return false;
        }
        try {
            Configuration $$22 = Configuration.create($$0);
            String $$3 = field_34410.format(Instant.now());
            this.field_34411 = class_156.method_654(new Recording($$22), $$2 -> {
                field_34407.forEach($$2::enable);
                $$2.setDumpOnExit(true);
                $$2.setToDisk(true);
                $$2.setName(String.format(Locale.ROOT, "%s-%s-%s", $$1.method_37986(), class_155.method_16673().comp_4025(), $$3));
            });
            Path $$4 = Paths.get(String.format(Locale.ROOT, "debug/%s-%s.jfr", $$1.method_37986(), $$3), new String[0]);
            class_4239.method_47525($$4.getParent());
            this.field_34411.setDestination($$4);
            this.field_34411.start();
            this.method_38660();
        }
        catch (IOException | ParseException $$5) {
            field_34408.warn("Failed to start jfr profiling", (Throwable)$$5);
            return false;
        }
        field_34408.info("Started flight recorder profiling id({}):name({}) - will dump to {} on exit or stop command", new Object[]{this.field_34411.getId(), this.field_34411.getName(), this.field_34411.getDestination()});
        return true;
    }

    private void method_38660() {
        FlightRecorder.addListener(new FlightRecorderListener(){
            final class_6507 field_63279 = new class_6507(() -> {
                class_6505.this.field_34411 = null;
            });

            @Override
            public void recordingStateChanged(Recording $$0) {
                if ($$0 != class_6505.this.field_34411) {
                    return;
                }
                switch ($$0.getState()) {
                    case STOPPED: {
                        this.field_63279.method_38663($$0.getDestination());
                        FlightRecorder.removeListener(this);
                        break;
                    }
                }
            }
        });
    }

    @Override
    public void method_75087(int $$0) {
        if (ClientFpsEvent.TYPE.isEnabled()) {
            this.field_63275 = $$0;
        }
    }

    @Override
    public void method_38654(float $$0) {
        if (ServerTickTimeEvent.TYPE.isEnabled()) {
            this.field_35577 = $$0;
        }
    }

    @Override
    public void method_38656(class_2539 $$0, class_9145<?> $$1, SocketAddress $$2, int $$3) {
        if (PacketReceivedEvent.TYPE.isEnabled()) {
            new PacketReceivedEvent($$0.method_10785(), $$1.comp_2230().method_56444(), $$1.comp_2231().toString(), $$2, $$3).commit();
        }
        if (NetworkSummaryEvent.TYPE.isEnabled()) {
            this.method_39429($$2).method_39496($$3);
        }
    }

    @Override
    public void method_38657(class_2539 $$0, class_9145<?> $$1, SocketAddress $$2, int $$3) {
        if (PacketSentEvent.TYPE.isEnabled()) {
            new PacketSentEvent($$0.method_10785(), $$1.comp_2230().method_56444(), $$1.comp_2231().toString(), $$2, $$3).commit();
        }
        if (NetworkSummaryEvent.TYPE.isEnabled()) {
            this.method_39429($$2).method_39495($$3);
        }
    }

    private NetworkSummaryEvent.class_6779 method_39429(SocketAddress $$0) {
        return this.field_35578.computeIfAbsent($$0.toString(), NetworkSummaryEvent.class_6779::new);
    }

    @Override
    public void method_56979(class_9240 $$0, class_1923 $$1, class_4486 $$2, int $$3) {
        if (ChunkRegionReadEvent.TYPE.isEnabled()) {
            new ChunkRegionReadEvent($$0, $$1, $$2, $$3).commit();
        }
    }

    @Override
    public void method_56980(class_9240 $$0, class_1923 $$1, class_4486 $$2, int $$3) {
        if (ChunkRegionWriteEvent.TYPE.isEnabled()) {
            new ChunkRegionWriteEvent($$0, $$1, $$2, $$3).commit();
        }
    }

    @Override
    public @Nullable class_6613 method_38659() {
        if (!WorldLoadFinishedEvent.TYPE.isEnabled()) {
            return null;
        }
        WorldLoadFinishedEvent $$0 = new WorldLoadFinishedEvent();
        $$0.begin();
        return $$1 -> $$0.commit();
    }

    @Override
    public @Nullable class_6613 method_38655(class_1923 $$0, class_5321<class_1937> $$12, String $$2) {
        if (!ChunkGenerationEvent.TYPE.isEnabled()) {
            return null;
        }
        ChunkGenerationEvent $$3 = new ChunkGenerationEvent($$0, $$12, $$2);
        $$3.begin();
        return $$1 -> $$3.commit();
    }

    @Override
    public @Nullable class_6613 method_65105(class_1923 $$0, class_5321<class_1937> $$12, class_6880<class_3195> $$2) {
        if (!StructureGenerationEvent.TYPE.isEnabled()) {
            return null;
        }
        StructureGenerationEvent $$3 = new StructureGenerationEvent($$0, $$2, $$12);
        $$3.begin();
        return $$1 -> {
            $$0.success = $$1;
            $$3.commit();
        };
    }
}

