/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.transform;

import io.github.douira.glsl_transformer.ast.transform.PresentSourceLocation;
import io.github.douira.glsl_transformer.ast.transform.SourceLocation;

public class NamedSourceLocation
extends PresentSourceLocation {
    public final String sourceName;

    public NamedSourceLocation(int parsedLine, int line, String sourceName) {
        super(parsedLine, line);
        this.sourceName = sourceName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean needsPrint(int printedLines, PresentSourceLocation lastPrinted, int lastLocationPrintedLines) {
        if (lastPrinted == null) {
            return true;
        }
        if (printedLines + lastPrinted.line - lastLocationPrintedLines != this.line) return true;
        if (!(lastPrinted instanceof NamedSourceLocation)) return true;
        NamedSourceLocation lastNamed = (NamedSourceLocation)lastPrinted;
        if (!this.sourceName.equals(lastNamed.sourceName)) return true;
        return false;
    }

    @Override
    public SourceLocation createFromPrevious(int parsedLine) {
        return new NamedSourceLocation(parsedLine, this.line, this.sourceName);
    }

    @Override
    public SourceLocation createFromPrevious(int parsedLine, int line) {
        return new NamedSourceLocation(parsedLine, line, this.sourceName);
    }
}

