/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLootTableProvider;
import net.fabricmc.fabric.impl.datagen.loot.FabricLootTableProviderImpl;
import net.minecraft.class_1299;
import net.minecraft.class_173;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7701;
import net.minecraft.class_7789;
import net.minecraft.class_7923;

public abstract class FabricEntityLootTableProvider
extends class_7789
implements FabricLootTableProvider {
    private final FabricDataOutput output;
    private final Set<class_2960> excludedFromStrictValidation = new HashSet<class_2960>();
    private final CompletableFuture<class_7225.class_7874> registryLookupFuture;

    protected FabricEntityLootTableProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(class_7701.field_40180.method_45383(), registryLookup.join());
        this.output = output;
        this.registryLookupFuture = registryLookup;
    }

    public abstract void method_10400();

    public void excludeFromStrictValidation(class_1299<?> entityType) {
        this.excludedFromStrictValidation.add(class_7923.field_41177.method_10221(entityType));
    }

    public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> biConsumer) {
        this.method_10400();
        for (Map tables : this.field_40615.values()) {
            for (Map.Entry entry : tables.entrySet()) {
                biConsumer.accept((class_5321<class_52>)((class_5321)entry.getKey()), (class_52.class_53)entry.getValue());
            }
        }
        if (this.output.isStrictValidationEnabled()) {
            HashSet missing = Sets.newHashSet();
            for (class_2960 entityTypeId : class_7923.field_41177.method_10235()) {
                if (!entityTypeId.method_12836().equals(this.output.getModId())) continue;
                class_1299 entityType = (class_1299)class_7923.field_41177.method_63535(entityTypeId);
                entityType.method_16351().ifPresent(mainLootTableKey -> {
                    if (!mainLootTableKey.method_29177().method_12836().equals(this.output.getModId())) {
                        return;
                    }
                    Map tables = (Map)this.field_40615.get(entityType);
                    if (tables == null || !tables.containsKey(mainLootTableKey)) {
                        missing.add(entityTypeId);
                    }
                });
            }
            missing.removeAll(this.excludedFromStrictValidation);
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing loot table(s) for %s".formatted(missing));
            }
        }
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return FabricLootTableProviderImpl.run(writer, this, class_173.field_1173, this.output, this.registryLookupFuture);
    }

    public String method_10321() {
        return "Entity Loot Tables";
    }
}

