/*
 * Decompiled with CFR 0.152.
 */
package com.jimxbcn.clientlock.sync;

import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class UpdaterMain {
    private UpdaterMain() {
    }

    public static void main(String[] args) {
        try {
            if (args.length < 5) {
                System.err.println("Usage: UpdaterMain <parentPid> <pendingDirName> <quarantineDirName> <relaunchEnabled> <relaunchCommandB64>");
                System.exit(2);
            }
            long parentPid = Long.parseLong(args[0]);
            String pendingDirName = args[1];
            String quarantineDirName = args[2];
            boolean relaunchEnabled = Boolean.parseBoolean(args[3]);
            String relaunchCmd = UpdaterMain.decodeB64(args[4]);
            Path cwd = Path.of(".", new String[0]).toAbsolutePath().normalize();
            Path modsDir = cwd.resolve("mods");
            Path pendingDir = modsDir.resolve(pendingDirName);
            Path downloadsDir = pendingDir.resolve("downloads");
            Path applyFile = pendingDir.resolve("apply.txt");
            Path quarantineDir = modsDir.resolve(quarantineDirName);
            UpdaterMain.waitForPid(parentPid, 120);
            if (!Files.exists(applyFile, new LinkOption[0])) {
                System.out.println("[clientlock-updater] No apply.txt present; nothing to do.");
                System.exit(0);
            }
            Files.createDirectories(quarantineDir, new FileAttribute[0]);
            List<Op> ops = UpdaterMain.parseApplyFile(applyFile);
            if (ops.isEmpty()) {
                System.out.println("[clientlock-updater] apply.txt empty; nothing to do.");
                UpdaterMain.safeDelete(applyFile);
                System.exit(0);
            }
            System.out.println("[clientlock-updater] Applying " + ops.size() + " operations...");
            for (Op op : ops) {
                if (op.kind != Kind.REMOVE) continue;
                UpdaterMain.quarantine(modsDir.resolve(op.file), quarantineDir);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            for (Op op : ops) {
                if (op.kind != Kind.ADD) continue;
                Path src = downloadsDir.resolve(op.file);
                Path dst = modsDir.resolve(op.file);
                if (!Files.exists(src, new LinkOption[0])) {
                    System.out.println("[clientlock-updater] Missing staged file: " + String.valueOf(src));
                    continue;
                }
                if (Files.exists(dst, new LinkOption[0])) {
                    UpdaterMain.quarantine(dst, quarantineDir);
                }
                UpdaterMain.moveReplace(src, dst);
                System.out.println("[clientlock-updater] Installed: " + op.file);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            UpdaterMain.safeDelete(applyFile);
            try {
                if (Files.isDirectory(downloadsDir, new LinkOption[0]) && UpdaterMain.isDirEmpty(downloadsDir)) {
                    Files.deleteIfExists(downloadsDir);
                }
                if (Files.isDirectory(pendingDir, new LinkOption[0]) && UpdaterMain.isDirEmpty(pendingDir)) {
                    Files.deleteIfExists(pendingDir);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("[clientlock-updater] Done.");
            if (relaunchEnabled && relaunchCmd != null && !relaunchCmd.isBlank()) {
                System.out.println("[clientlock-updater] Relaunch: " + relaunchCmd);
                UpdaterMain.relaunch(relaunchCmd);
            }
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private static void waitForPid(long pid, int timeoutSeconds) throws InterruptedException {
        long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(timeoutSeconds);
        while (System.nanoTime() < deadline) {
            if (ProcessHandle.of(pid).isEmpty()) {
                return;
            }
            Thread.sleep(200L);
        }
        System.out.println("[clientlock-updater] Warning: parent PID still alive after timeout; continuing anyway.");
    }

    private static String decodeB64(String b64) {
        if (b64 == null || b64.isBlank()) {
            return "";
        }
        try {
            return new String(Base64.getDecoder().decode(b64), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static void relaunch(String cmd) {
        try {
            boolean win = System.getProperty("os.name", "").toLowerCase(Locale.ROOT).contains("win");
            ProcessBuilder pb = win ? new ProcessBuilder("cmd.exe", "/c", cmd) : new ProcessBuilder("sh", "-c", cmd);
            pb.inheritIO();
            pb.start();
        }
        catch (Exception e) {
            System.out.println("[clientlock-updater] Relaunch failed: " + e.getMessage());
        }
    }

    private static void quarantine(Path target, Path quarantineDir) {
        try {
            if (!Files.exists(target, new LinkOption[0])) {
                return;
            }
            String name = target.getFileName().toString();
            String stamp = Instant.now().toString().replace(':', '-');
            Path dst = quarantineDir.resolve(stamp + "_" + name);
            UpdaterMain.moveReplace(target, dst);
            System.out.println("[clientlock-updater] Quarantined: " + name);
        }
        catch (Exception e) {
            System.out.println("[clientlock-updater] Could not quarantine " + String.valueOf(target) + " -> " + String.valueOf(quarantineDir) + " (" + e.getMessage() + ")");
        }
    }

    private static void moveReplace(Path src, Path dst) throws Exception {
        try {
            Files.createDirectories(dst.getParent(), new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Files.move(src, dst, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            Files.move(src, dst, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static void safeDelete(Path p) {
        try {
            Files.deleteIfExists(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isDirEmpty(Path dir) throws Exception {
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir);){
            boolean bl = !ds.iterator().hasNext();
            return bl;
        }
    }

    private static List<Op> parseApplyFile(Path applyFile) throws Exception {
        List<String> lines = Files.readAllLines(applyFile, StandardCharsets.UTF_8);
        ArrayList<Op> ops = new ArrayList<Op>();
        for (String raw : lines) {
            int idx;
            String line;
            if (raw == null || (line = raw.trim()).isEmpty() || line.startsWith("#") || (idx = line.indexOf(124)) <= 0 || idx >= line.length() - 1) continue;
            String k = line.substring(0, idx).trim().toUpperCase(Locale.ROOT);
            String f = line.substring(idx + 1).trim();
            if (f.isEmpty()) continue;
            if (k.equals("ADD")) {
                ops.add(new Op(Kind.ADD, f));
                continue;
            }
            if (!k.equals("REMOVE")) continue;
            ops.add(new Op(Kind.REMOVE, f));
        }
        return ops;
    }

    private static final class Op {
        final Kind kind;
        final String file;

        Op(Kind kind, String file) {
            this.kind = kind;
            this.file = file;
        }
    }

    private static enum Kind {
        ADD,
        REMOVE;

    }
}

