/*
 * Decompiled with CFR 0.152.
 */
package com.jimxbcn.clientlock.sync;

import java.util.concurrent.atomic.AtomicReference;

public final class SplashStatus {
    private static final AtomicReference<Snapshot> SNAPSHOT = new AtomicReference<Snapshot>(new Snapshot(Phase.IDLE, "", 0.0));

    private SplashStatus() {
    }

    public static void set(Phase phase, String message, double progress) {
        if (message == null) {
            message = "";
        }
        double p = Math.max(0.0, Math.min(1.0, progress));
        SNAPSHOT.set(new Snapshot(phase, message, p));
    }

    public static Snapshot get() {
        return SNAPSHOT.get();
    }

    public record Snapshot(Phase phase, String message, double progress) {
    }

    public static enum Phase {
        IDLE,
        APPLY_PENDING,
        SCANNING_LOCAL,
        CONTACTING_SERVER,
        DOWNLOADING,
        VERIFYING,
        IN_SYNC,
        RESTART_REQUIRED,
        ERROR;

    }
}

