/*
 * Decompiled with CFR 0.152.
 */
package com.jimxbcn.clientlock.sync;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class FabricModJsonReader {
    private FabricModJsonReader() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Optional<FabricMod> readPrimary(String jarPath) {
        try (ZipFile zf = new ZipFile(jarPath);){
            Optional<FabricMod> optional;
            block24: {
                String name;
                String version;
                String id;
                InputStream in;
                block22: {
                    Optional<FabricMod> optional2;
                    block23: {
                        JsonElement root;
                        block20: {
                            Optional<FabricMod> optional3;
                            block21: {
                                ZipEntry e = zf.getEntry("fabric.mod.json");
                                if (e == null) {
                                    Optional<FabricMod> optional4 = Optional.empty();
                                    return optional4;
                                }
                                in = zf.getInputStream(e);
                                try {
                                    String json = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                                    root = JsonParser.parseString((String)json);
                                    if (root.isJsonObject()) break block20;
                                    optional3 = Optional.empty();
                                    if (in == null) break block21;
                                }
                                catch (Throwable throwable) {
                                    if (in != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                in.close();
                            }
                            return optional3;
                        }
                        JsonObject o = root.getAsJsonObject();
                        id = FabricModJsonReader.getString(o, "id");
                        version = FabricModJsonReader.getString(o, "version");
                        name = FabricModJsonReader.getString(o, "name");
                        if (id != null && version != null) break block22;
                        optional2 = Optional.empty();
                        if (in == null) break block23;
                        in.close();
                    }
                    return optional2;
                }
                if (name == null) {
                    name = id;
                }
                optional = Optional.of(new FabricMod(id, version, name));
                if (in == null) break block24;
                in.close();
            }
            return optional;
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    private static String getString(JsonObject o, String key) {
        JsonElement e = o.get(key);
        if (e == null || !e.isJsonPrimitive()) {
            return null;
        }
        try {
            return e.getAsString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public record FabricMod(String id, String version, String name) {
    }
}

