/*
 * Decompiled with CFR 0.152.
 */
package com.jimxbcn.clientlock.mixin;

import com.jimxbcn.clientlock.ClientLockClient;
import com.jimxbcn.clientlock.sync.SplashStatus;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_425;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_425.class})
public abstract class SplashOverlayMixin {
    @Inject(method={"method_25394"}, at={@At(value="HEAD")}, require=0)
    private void clientlock$preFillBackdrop(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        class_310 mc = class_310.method_1551();
        int w = mc.method_22683().method_4486();
        int h = mc.method_22683().method_4502();
        if (w <= 0 || h <= 0) {
            return;
        }
        int color = ClientLockClient.configOrDefault().loadingColorArgb();
        context.method_25294(0, 0, w, h, color);
    }

    @ModifyArg(method={"method_25394"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_425;method_35732(II)I"), index=0, require=0)
    private int clientlock$replaceSplashBaseColor(int original) {
        return ClientLockClient.configOrDefault().loadingColorArgb();
    }

    @ModifyArg(method={"method_25394"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_332;method_25294(IIIII)V"), index=4, require=0)
    private int clientlock$replaceSplashColor_5(int original) {
        return ClientLockClient.configOrDefault().loadingColorArgb();
    }

    @ModifyArg(method={"method_25394"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_332;fill(IIIIII)V"), index=5, require=0)
    private int clientlock$replaceSplashColor_6(int original) {
        return ClientLockClient.configOrDefault().loadingColorArgb();
    }

    @ModifyArgs(method={"method_25394"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;clearColor(FFFF)V"), require=0)
    private void clientlock$replaceClearColor(Args args) {
        int argb = ClientLockClient.configOrDefault().loadingColorArgb();
        float a = (float)(argb >>> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >>> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >>> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        args.set(0, (Object)Float.valueOf(r));
        args.set(1, (Object)Float.valueOf(g));
        args.set(2, (Object)Float.valueOf(b));
        args.set(3, (Object)Float.valueOf(a));
    }

    @Inject(method={"method_25394"}, at={@At(value="TAIL")}, require=0)
    private void clientlock$renderStatus(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        SplashStatus.Snapshot st = SplashStatus.get();
        if (ClientLockClient.isStoppingNow()) {
            return;
        }
        if (st.phase() == SplashStatus.Phase.IDLE && (st.message() == null || st.message().isBlank())) {
            return;
        }
        class_310 mc = class_310.method_1551();
        int w = mc.method_22683().method_4486();
        int h = mc.method_22683().method_4502();
        String msg = st.message();
        if (msg == null || msg.isBlank()) {
            msg = st.phase().name();
        }
        int x = 8;
        int y = h - 34;
        int textColor = -1;
        int shadowBg = 0x66000000;
        int tw = mc.field_1772.method_1727(msg);
        context.method_25294(x - 4, y - 4, x + tw + 4, y + 10, shadowBg);
        context.method_51433(mc.field_1772, msg, x, y, textColor, true);
        float p = (float)st.progress();
        if (p > 0.0f) {
            int barW = Math.min(220, w - 16);
            int barX = 8;
            int barY = y + 14;
            context.method_25294(barX, barY, barX + barW, barY + 4, shadowBg);
            int fill = (int)((float)barW * Math.max(0.0f, Math.min(1.0f, p)));
            int accent = ClientLockClient.configOrDefault().loadingColorArgb();
            context.method_25294(barX, barY, barX + fill, barY + 4, accent);
        }
    }
}

