/*
 * Decompiled with CFR 0.152.
 */
package com.jimxbcn.clientlock;

import com.jimxbcn.clientlock.ClientLockConfig;
import java.util.HashMap;

public final class TomlLite {
    private TomlLite() {
    }

    private static String stripComments(String raw) {
        if (raw == null || raw.isEmpty()) {
            return "";
        }
        boolean inSingle = false;
        boolean inDouble = false;
        boolean escape = false;
        StringBuilder sb = new StringBuilder(raw.length());
        for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            if (inDouble) {
                if (escape) {
                    escape = false;
                } else if (c == '\\') {
                    escape = true;
                } else if (c == '\"') {
                    inDouble = false;
                }
                sb.append(c);
                continue;
            }
            if (inSingle) {
                if (c == '\'') {
                    inSingle = false;
                }
                sb.append(c);
                continue;
            }
            if (c == '#') break;
            if (c == '\"') {
                inDouble = true;
            } else if (c == '\'') {
                inSingle = true;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static ClientLockConfig parse(String toml) {
        String[] lines;
        if (toml == null) {
            return null;
        }
        HashMap<String, String> kv = new HashMap<String, String>();
        String section = "";
        for (String raw : lines = toml.split("\r?\n")) {
            String line = TomlLite.stripComments(raw);
            if ((line = line.trim()).isEmpty()) continue;
            if (line.startsWith("[") && line.endsWith("]") && line.length() >= 3) {
                section = line.substring(1, line.length() - 1).trim();
                continue;
            }
            int eq = line.indexOf(61);
            if (eq <= 0) continue;
            String key = line.substring(0, eq).trim();
            String val = line.substring(eq + 1).trim();
            val = TomlLite.stripOptionalQuotes(val);
            String fullKey = section.isEmpty() ? key : section + "." + key;
            kv.put(fullKey, val);
        }
        ClientLockConfig def = ClientLockConfig.defaults();
        String apiUrl = kv.getOrDefault("api.url", def.api().url());
        String host = kv.getOrDefault("server.host", def.server().host());
        int port = TomlLite.parseInt((String)kv.get("server.port"), def.server().port());
        String bg = kv.getOrDefault("ui.background", def.ui().background());
        String lc = kv.getOrDefault("ui.loading_color", def.ui().loadingColor());
        boolean enforce = TomlLite.parseBool((String)kv.get("sync.enforce"), def.sync().enforce());
        boolean autoApply = TomlLite.parseBool((String)kv.get("sync.auto_apply"), def.sync().autoApply());
        boolean allowSelfUpdate = TomlLite.parseBool((String)kv.get("sync.allow_self_update"), def.sync().allowSelfUpdate());
        boolean sendSha = TomlLite.parseBool((String)kv.get("sync.send_sha256"), def.sync().sendSha256());
        boolean applyAfterExit = TomlLite.parseBool((String)kv.get("sync.apply_after_exit"), def.sync().applyAfterExit());
        boolean relaunchEnabled = TomlLite.parseBool((String)kv.get("sync.relaunch_enabled"), def.sync().relaunchEnabled());
        String relaunchCommand = kv.getOrDefault("sync.relaunch_command", def.sync().relaunchCommand());
        String pending = kv.getOrDefault("sync.pending_dir", def.sync().pendingDir());
        String quarantine = kv.getOrDefault("sync.quarantine_dir", def.sync().quarantineDir());
        boolean production = TomlLite.parseBool((String)kv.get("logging.production"), def.logging().production());
        return new ClientLockConfig(new ClientLockConfig.Api(apiUrl), new ClientLockConfig.Server(host, port), new ClientLockConfig.Ui(bg, lc), new ClientLockConfig.Sync(enforce, autoApply, allowSelfUpdate, sendSha, applyAfterExit, relaunchEnabled, relaunchCommand, pending, quarantine), new ClientLockConfig.Logging(production));
    }

    private static String stripOptionalQuotes(String v) {
        String s = v.trim();
        if ((s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) && s.length() >= 2) {
            return s.substring(1, s.length() - 1);
        }
        if (s.equals("\"") || s.equals("'")) {
            return "";
        }
        return s;
    }

    private static int parseInt(String v, int def) {
        if (v == null) {
            return def;
        }
        try {
            return Integer.parseInt(v.trim());
        }
        catch (Exception e) {
            return def;
        }
    }

    private static boolean parseBool(String v, boolean def) {
        if (v == null) {
            return def;
        }
        String s = v.trim().toLowerCase();
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        return def;
    }

    public static String toToml(ClientLockConfig cfg) {
        return "[api]\nurl = \"" + TomlLite.escape(cfg.api().url()) + "\"\n\n[server]\nhost = \"" + TomlLite.escape(cfg.server().host()) + "\"\nport = " + cfg.server().port() + "\n\n[ui]\nbackground = \"" + TomlLite.escape(cfg.ui().background()) + "\"\nloading_color = \"" + TomlLite.escape(cfg.ui().loadingColor()) + "\"\n\n[sync]\nenforce = " + cfg.sync().enforce() + "\nauto_apply = " + cfg.sync().autoApply() + "\nallow_self_update = " + cfg.sync().allowSelfUpdate() + "\nsend_sha256 = " + cfg.sync().sendSha256() + "\napply_after_exit = " + cfg.sync().applyAfterExit() + "\nrelaunch_enabled = " + cfg.sync().relaunchEnabled() + "\nrelaunch_command = \"" + TomlLite.escape(cfg.sync().relaunchCommand()) + "\"\npending_dir = \"" + TomlLite.escape(cfg.sync().pendingDir()) + "\"\nquarantine_dir = \"" + TomlLite.escape(cfg.sync().quarantineDir()) + "\"\n\n[logging]\nproduction = " + cfg.logging().production() + "\n";
    }

    private static String escape(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

