/*
 * Decompiled with CFR 0.152.
 */
package com.jimxbcn.clientlock;

public final class ColorUtil {
    private ColorUtil() {
    }

    public static int parseToArgb(String s, int fallback) {
        if (s == null) {
            return fallback;
        }
        String v = s.trim();
        if (v.startsWith("\"") && v.endsWith("\"") && v.length() >= 2) {
            v = v.substring(1, v.length() - 1).trim();
        }
        if (!v.startsWith("#")) {
            return fallback;
        }
        v = v.substring(1);
        try {
            if (v.length() == 6) {
                int rgb = Integer.parseUnsignedInt(v, 16);
                return 0xFF000000 | rgb;
            }
            if (v.length() == 8) {
                return (int)Long.parseLong(v, 16);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fallback;
    }
}

