/*
 * Decompiled with CFR 0.152.
 */
package com.jimxbcn.clientlock;

import com.jimxbcn.clientlock.ClientLockLog;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public final class ClientLockRuntime {
    private static final AtomicReference<Consumer<String>> STOPPER = new AtomicReference();
    private static final AtomicBoolean STOP_REQUESTED = new AtomicBoolean(false);

    private ClientLockRuntime() {
    }

    public static void setStopper(Consumer<String> stopper) {
        STOPPER.set(stopper);
    }

    public static boolean isStopRequested() {
        return STOP_REQUESTED.get();
    }

    public static void requestStop(String reason) {
        if (!STOP_REQUESTED.compareAndSet(false, true)) {
            return;
        }
        Consumer<String> s = STOPPER.get();
        if (s != null) {
            s.accept(reason);
        } else {
            ClientLockLog.LOGGER.warn("Stop requested but stopper not set. Reason={}", (Object)reason);
        }
    }
}

