/*
 * Decompiled with CFR 0.152.
 */
package com.jimxbcn.clientlock;

import com.jimxbcn.clientlock.ColorUtil;
import java.util.Objects;

public record ClientLockConfig(Api api, Server server, Ui ui, Sync sync, Logging logging) {
    public static ClientLockConfig defaults() {
        return new ClientLockConfig(new Api("https://minecraft.jimxbcn.xyz/"), new Server("play.example.com", 25565), new Ui("clientlock:textures/gui/background.png", "#FF1A237E"), new Sync(true, true, true, true, true, false, "", ".clientlock_pending", ".clientlock_quarantine"), new Logging(true));
    }

    public int loadingColorArgb() {
        return ColorUtil.parseToArgb(this.ui.loadingColor, -15064194);
    }

    public record Api(String url) {
        public Api(String url) {
            String lower;
            Object u;
            Object object = u = url == null ? "" : url.trim();
            if (((String)u).isEmpty()) {
                u = "https://minecraft.jimxbcn.xyz/";
            }
            if ((lower = ((String)u).toLowerCase()).endsWith("mods_inventory.php")) {
                u = ((String)u).substring(0, ((String)u).length() - "mods_inventory.php".length());
            }
            if (!((String)u).endsWith("/")) {
                u = (String)u + "/";
            }
            this.url = url = u;
        }

        public String modsInventoryUrl() {
            return this.url + "mods_inventory.php";
        }

        public String resolve(String relativePath) {
            if (relativePath == null || relativePath.isBlank()) {
                return this.url;
            }
            String p = relativePath.startsWith("/") ? relativePath.substring(1) : relativePath;
            return this.url + p;
        }
    }

    public record Server(String host, int port) {
        public Server {
            Objects.requireNonNull(host);
        }
    }

    public record Ui(String background, String loadingColor) {
        public Ui {
            Objects.requireNonNull(background);
            Objects.requireNonNull(loadingColor);
        }
    }

    public record Sync(boolean enforce, boolean autoApply, boolean allowSelfUpdate, boolean sendSha256, boolean applyAfterExit, boolean relaunchEnabled, String relaunchCommand, String pendingDir, String quarantineDir) {
        public Sync {
            Objects.requireNonNull(relaunchCommand);
            Objects.requireNonNull(pendingDir);
            Objects.requireNonNull(quarantineDir);
        }
    }

    public record Logging(boolean production) {
    }
}

