/*
 * Decompiled with CFR 0.152.
 */
package com.jimxbcn.clientlock;

import com.jimxbcn.clientlock.ClientLockConfig;
import com.jimxbcn.clientlock.ClientLockRuntime;
import com.jimxbcn.clientlock.ConfigManager;
import com.jimxbcn.clientlock.sync.ModSyncService;
import com.jimxbcn.clientlock.sync.PendingApplier;
import com.jimxbcn.clientlock.sync.SplashStatus;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public final class ClientLockClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"clientlock");
    private static volatile ClientLockConfig CONFIG;
    private static volatile ShutdownSequence SHUTDOWN;
    private static volatile boolean STOPPING_NOW;

    public static ClientLockConfig getConfig() {
        return CONFIG;
    }

    public static boolean isStoppingNow() {
        return STOPPING_NOW;
    }

    public void onInitializeClient() {
        CONFIG = ConfigManager.loadOrCreate();
        ClientLockRuntime.setStopper(ClientLockClient::beginShutdownSequence);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            ShutdownSequence seq = SHUTDOWN;
            if (seq != null) {
                seq.tick(client);
            }
        });
        boolean hadPending = false;
        if (!CONFIG.sync().applyAfterExit()) {
            hadPending = PendingApplier.applyIfPresent(CONFIG);
        }
        if (!hadPending) {
            SplashStatus.set(SplashStatus.Phase.IDLE, "Iniciando\u2026", 0.05);
        }
        ModSyncService.startSyncAsync(CONFIG);
    }

    private static void beginShutdownSequence(String reason) {
        if (SHUTDOWN != null) {
            return;
        }
        ClientLockConfig cfg = ClientLockClient.configOrDefault();
        SHUTDOWN = ShutdownSequence.create(cfg, reason == null ? "" : reason);
        SplashStatus.set(SplashStatus.Phase.RESTART_REQUIRED, "Sincronizando modpack\u2026", 0.0);
    }

    public static ClientLockConfig configOrDefault() {
        ClientLockConfig c = CONFIG;
        return c != null ? c : ClientLockConfig.defaults();
    }

    public static String modVersion() {
        return FabricLoader.getInstance().getModContainer("clientlock").map(c -> c.getMetadata().getVersion().getFriendlyString()).orElse("unknown");
    }

    public static void requestStop(String reason) {
        ClientLockRuntime.requestStop(reason);
    }

    static {
        STOPPING_NOW = false;
    }

    @Environment(value=EnvType.CLIENT)
    private static final class ShutdownSequence {
        private static final long OP_DISPLAY_MS = 2000L;
        private static final long COUNTDOWN_MS = 5000L;
        private final List<String> steps;
        private final String reason;
        private int index = 0;
        private long nextStepAtMs = 0L;
        private boolean summaryShown = false;
        private long countdownEndMs = 0L;
        private int lastCountdownShown = -1;
        private boolean scheduledStop = false;

        private ShutdownSequence(List<String> steps, String reason) {
            this.steps = steps;
            this.reason = reason;
        }

        static ShutdownSequence create(ClientLockConfig cfg, String reason) {
            List<String> steps = ShutdownSequence.readApplySteps(cfg);
            return new ShutdownSequence(steps, reason);
        }

        void tick(class_310 client) {
            long now = System.currentTimeMillis();
            if (this.countdownEndMs == 0L) {
                if (!this.summaryShown && !this.steps.isEmpty()) {
                    this.summaryShown = true;
                    SplashStatus.set(SplashStatus.Phase.RESTART_REQUIRED, "Se aplicar\u00e1n " + this.steps.size() + " cambios\u2026", 0.0);
                    this.nextStepAtMs = now + 2000L;
                    return;
                }
                if (this.steps.isEmpty()) {
                    this.countdownEndMs = now + 5000L;
                    this.lastCountdownShown = -1;
                    SplashStatus.set(SplashStatus.Phase.RESTART_REQUIRED, "Reiniciando para aplicar cambios\u2026", 1.0);
                    return;
                }
                if (this.nextStepAtMs == 0L) {
                    this.nextStepAtMs = now;
                }
                if (now >= this.nextStepAtMs) {
                    if (this.index < this.steps.size()) {
                        String msg = this.steps.get(this.index);
                        double p = Math.max(0.0, Math.min(1.0, this.steps.size() <= 1 ? 1.0 : (double)(this.index + 1) / (double)this.steps.size()));
                        SplashStatus.set(SplashStatus.Phase.RESTART_REQUIRED, msg, p);
                        ++this.index;
                        this.nextStepAtMs = now + 2000L;
                        return;
                    }
                    this.countdownEndMs = now + 5000L;
                    this.lastCountdownShown = -1;
                    SplashStatus.set(SplashStatus.Phase.RESTART_REQUIRED, "Reiniciando para aplicar cambios\u2026", 1.0);
                    return;
                }
                return;
            }
            long remainingMs = Math.max(0L, this.countdownEndMs - now);
            int remainingSec = (int)Math.ceil((double)remainingMs / 1000.0);
            if (remainingSec != this.lastCountdownShown) {
                this.lastCountdownShown = remainingSec;
                String msg = "Cerrando Minecraft en " + remainingSec + "s para aplicar el modpack\u2026";
                SplashStatus.set(SplashStatus.Phase.RESTART_REQUIRED, msg, 1.0);
            }
            if (remainingMs <= 0L && !this.scheduledStop) {
                this.scheduledStop = true;
                if (this.reason != null && !this.reason.isBlank()) {
                    LOGGER.warn("Stopping client: {}", (Object)this.reason);
                } else {
                    LOGGER.warn("Stopping client: modpack sync required");
                }
                STOPPING_NOW = true;
                client.execute(() -> ((class_310)client).method_1592());
                SHUTDOWN = null;
            }
        }

        private static List<String> readApplySteps(ClientLockConfig cfg) {
            ArrayList<String> steps = new ArrayList<String>();
            try {
                Path apply = Path.of("mods", new String[0]).resolve(cfg.sync().pendingDir()).resolve("apply.txt");
                if (!Files.exists(apply, new LinkOption[0])) {
                    return steps;
                }
                List<String> lines = Files.readAllLines(apply, StandardCharsets.UTF_8);
                ArrayList<CallSite> removes = new ArrayList<CallSite>();
                ArrayList<CallSite> adds = new ArrayList<CallSite>();
                for (String raw : lines) {
                    int idx;
                    String line;
                    if (raw == null || (line = raw.trim()).isEmpty() || line.startsWith("#") || (idx = line.indexOf(124)) <= 0 || idx >= line.length() - 1) continue;
                    String k = line.substring(0, idx).trim().toUpperCase(Locale.ROOT);
                    String f = line.substring(idx + 1).trim();
                    if (f.isEmpty()) continue;
                    if (k.equals("REMOVE")) {
                        removes.add((CallSite)((Object)("Cuarentena: " + f)));
                        continue;
                    }
                    if (!k.equals("ADD")) continue;
                    adds.add((CallSite)((Object)("Instalando: " + f)));
                }
                steps.addAll(removes);
                steps.addAll(adds);
                return steps;
            }
            catch (Exception ignored) {
                return steps;
            }
        }
    }
}

